/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.security.autoconfigure.actuate.web.servlet;

import org.springframework.boot.actuate.autoconfigure.web.ManagementContextConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.security.autoconfigure.actuate.web.servlet.PathPatternRequestMatcherProvider;
import org.springframework.boot.security.autoconfigure.actuate.web.servlet.RequestMatcherProvider;
import org.springframework.boot.webmvc.autoconfigure.DispatcherServletPath;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.servlet.DispatcherServlet;

@ManagementContextConfiguration(proxyBeanMethods=false)
@ConditionalOnClass(value={RequestMatcher.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
public class SecurityRequestMatchersManagementContextConfiguration {

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={DispatcherServlet.class})
    @ConditionalOnBean(value={DispatcherServletPath.class})
    public static class MvcRequestMatcherConfiguration {
        @Bean
        @ConditionalOnMissingBean
        public RequestMatcherProvider requestMatcherProvider(DispatcherServletPath servletPath) {
            return new PathPatternRequestMatcherProvider(arg_0 -> ((DispatcherServletPath)servletPath).getRelativePath(arg_0));
        }
    }
}

