/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.security.oauth2.server.resource.autoconfigure.servlet;

import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.security.autoconfigure.ConditionalOnDefaultWebSecurity;
import org.springframework.boot.security.oauth2.server.resource.autoconfigure.OAuth2ResourceServerProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.oauth2.server.resource.introspection.OpaqueTokenIntrospector;
import org.springframework.security.oauth2.server.resource.introspection.SpringOpaqueTokenIntrospector;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.util.Assert;

@Configuration(proxyBeanMethods=false)
class OAuth2ResourceServerOpaqueTokenConfiguration {
    OAuth2ResourceServerOpaqueTokenConfiguration() {
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnDefaultWebSecurity
    static class OAuth2SecurityFilterChainConfiguration {
        OAuth2SecurityFilterChainConfiguration() {
        }

        @Bean
        @ConditionalOnBean(value={OpaqueTokenIntrospector.class})
        SecurityFilterChain opaqueTokenSecurityFilterChain(HttpSecurity http) throws Exception {
            http.authorizeHttpRequests(requests -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)requests.anyRequest()).authenticated());
            http.oauth2ResourceServer(resourceServer -> resourceServer.opaqueToken(Customizer.withDefaults()));
            return (SecurityFilterChain)http.build();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingBean(value={OpaqueTokenIntrospector.class})
    static class OpaqueTokenIntrospectionClientConfiguration {
        OpaqueTokenIntrospectionClientConfiguration() {
        }

        @Bean
        @ConditionalOnProperty(name={"spring.security.oauth2.resourceserver.opaquetoken.introspection-uri"})
        SpringOpaqueTokenIntrospector opaqueTokenIntrospector(OAuth2ResourceServerProperties properties) {
            OAuth2ResourceServerProperties.Opaquetoken opaquetoken = properties.getOpaquetoken();
            String introspectionUri = opaquetoken.getIntrospectionUri();
            Assert.state((introspectionUri != null ? 1 : 0) != 0, (String)"'introspectionUri' must not be null");
            String clientId = opaquetoken.getClientId();
            Assert.state((clientId != null ? 1 : 0) != 0, (String)"'clientId' must not be null");
            String clientSecret = opaquetoken.getClientSecret();
            Assert.state((clientSecret != null ? 1 : 0) != 0, (String)"'clientSecret' must not be null");
            return SpringOpaqueTokenIntrospector.withIntrospectionUri((String)introspectionUri).clientId(clientId).clientSecret(clientSecret).build();
        }
    }
}

