/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.security.oauth2.server.resource.autoconfigure;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.source.InvalidConfigurationPropertyValueException;
import org.springframework.core.io.Resource;
import org.springframework.util.StreamUtils;

@ConfigurationProperties(value="spring.security.oauth2.resourceserver")
public class OAuth2ResourceServerProperties {
    private final Jwt jwt = new Jwt();
    private final Opaquetoken opaquetoken = new Opaquetoken();

    public Jwt getJwt() {
        return this.jwt;
    }

    public Opaquetoken getOpaquetoken() {
        return this.opaquetoken;
    }

    public static class Jwt {
        private String jwkSetUri;
        private List<String> jwsAlgorithms = Arrays.asList("RS256");
        private String issuerUri;
        private Resource publicKeyLocation;
        private List<String> audiences = new ArrayList<String>();
        private String authorityPrefix;
        private String authoritiesClaimDelimiter;
        private String authoritiesClaimName;
        private String principalClaimName;

        public String getJwkSetUri() {
            return this.jwkSetUri;
        }

        public void setJwkSetUri(String jwkSetUri) {
            this.jwkSetUri = jwkSetUri;
        }

        public List<String> getJwsAlgorithms() {
            return this.jwsAlgorithms;
        }

        public void setJwsAlgorithms(List<String> jwsAlgorithms) {
            this.jwsAlgorithms = jwsAlgorithms;
        }

        public String getIssuerUri() {
            return this.issuerUri;
        }

        public void setIssuerUri(String issuerUri) {
            this.issuerUri = issuerUri;
        }

        public Resource getPublicKeyLocation() {
            return this.publicKeyLocation;
        }

        public void setPublicKeyLocation(Resource publicKeyLocation) {
            this.publicKeyLocation = publicKeyLocation;
        }

        public List<String> getAudiences() {
            return this.audiences;
        }

        public void setAudiences(List<String> audiences) {
            this.audiences = audiences;
        }

        public String getAuthorityPrefix() {
            return this.authorityPrefix;
        }

        public void setAuthorityPrefix(String authorityPrefix) {
            this.authorityPrefix = authorityPrefix;
        }

        public String getAuthoritiesClaimDelimiter() {
            return this.authoritiesClaimDelimiter;
        }

        public void setAuthoritiesClaimDelimiter(String authoritiesClaimDelimiter) {
            this.authoritiesClaimDelimiter = authoritiesClaimDelimiter;
        }

        public String getAuthoritiesClaimName() {
            return this.authoritiesClaimName;
        }

        public void setAuthoritiesClaimName(String authoritiesClaimName) {
            this.authoritiesClaimName = authoritiesClaimName;
        }

        public String getPrincipalClaimName() {
            return this.principalClaimName;
        }

        public void setPrincipalClaimName(String principalClaimName) {
            this.principalClaimName = principalClaimName;
        }

        public String readPublicKey() throws IOException {
            String key = "spring.security.oauth2.resourceserver.public-key-location";
            if (this.publicKeyLocation == null) {
                throw new InvalidConfigurationPropertyValueException(key, (Object)this.publicKeyLocation, "No public key location specified");
            }
            if (!this.publicKeyLocation.exists()) {
                throw new InvalidConfigurationPropertyValueException(key, (Object)this.publicKeyLocation, "Public key location does not exist");
            }
            try (InputStream inputStream = this.publicKeyLocation.getInputStream();){
                String string = StreamUtils.copyToString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                return string;
            }
        }
    }

    public static class Opaquetoken {
        private String clientId;
        private String clientSecret;
        private String introspectionUri;

        public String getClientId() {
            return this.clientId;
        }

        public void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public String getClientSecret() {
            return this.clientSecret;
        }

        public void setClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
        }

        public String getIntrospectionUri() {
            return this.introspectionUri;
        }

        public void setIntrospectionUri(String introspectionUri) {
            this.introspectionUri = introspectionUri;
        }
    }
}

