/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.rsocket.autoconfigure;

import io.rsocket.core.RSocketServer;
import io.rsocket.frame.decoder.PayloadDecoder;
import io.rsocket.transport.netty.server.TcpServerTransport;
import java.util.function.Consumer;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.AllNestedConditions;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.reactor.netty.autoconfigure.ReactorNettyConfigurations;
import org.springframework.boot.rsocket.autoconfigure.RSocketProperties;
import org.springframework.boot.rsocket.autoconfigure.RSocketStrategiesAutoConfiguration;
import org.springframework.boot.rsocket.autoconfigure.RSocketWebSocketNettyRouteProvider;
import org.springframework.boot.rsocket.context.RSocketServerBootstrap;
import org.springframework.boot.rsocket.netty.NettyRSocketServerFactory;
import org.springframework.boot.rsocket.server.RSocketServerCustomizer;
import org.springframework.boot.rsocket.server.RSocketServerFactory;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.context.annotation.Import;
import org.springframework.core.io.buffer.NettyDataBufferFactory;
import org.springframework.http.client.ReactorResourceFactory;
import org.springframework.messaging.rsocket.RSocketStrategies;
import org.springframework.messaging.rsocket.annotation.support.RSocketMessageHandler;
import org.springframework.util.Assert;
import org.springframework.util.unit.DataSize;
import reactor.netty.http.server.HttpServer;
import reactor.netty.http.server.WebsocketServerSpec;

@AutoConfiguration(after={RSocketStrategiesAutoConfiguration.class})
@ConditionalOnClass(value={RSocketServer.class, RSocketStrategies.class, HttpServer.class, TcpServerTransport.class})
@ConditionalOnBean(value={RSocketMessageHandler.class})
@EnableConfigurationProperties(value={RSocketProperties.class})
public final class RSocketServerAutoConfiguration {

    static class OnRSocketWebServerCondition
    extends AllNestedConditions {
        OnRSocketWebServerCondition() {
            super(ConfigurationCondition.ConfigurationPhase.PARSE_CONFIGURATION);
        }

        @ConditionalOnProperty(name={"spring.rsocket.server.transport"}, havingValue="websocket")
        static class HasWebsocketTransportConfigured {
            HasWebsocketTransportConfigured() {
            }
        }

        @ConditionalOnProperty(value={"spring.rsocket.server.mapping-path"})
        static class HasMappingPathConfigured {
            HasMappingPathConfigured() {
            }
        }

        @ConditionalOnProperty(name={"spring.rsocket.server.port"}, matchIfMissing=true)
        static class HasNoPortConfigured {
            HasNoPortConfigured() {
            }
        }

        @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
        static class IsReactiveWebApplication {
            IsReactiveWebApplication() {
            }
        }
    }

    @ConditionalOnProperty(value={"spring.rsocket.server.port"})
    @ConditionalOnClass(value={ReactorResourceFactory.class})
    @Configuration(proxyBeanMethods=false)
    @Import(value={ReactorNettyConfigurations.ReactorResourceFactoryConfiguration.class})
    static class EmbeddedServerConfiguration {
        EmbeddedServerConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        RSocketServerFactory rSocketServerFactory(RSocketProperties properties, ReactorResourceFactory resourceFactory, ObjectProvider<RSocketServerCustomizer> customizers, ObjectProvider<SslBundles> sslBundles) {
            NettyRSocketServerFactory factory = new NettyRSocketServerFactory();
            factory.setResourceFactory(resourceFactory);
            factory.setTransport(properties.getServer().getTransport());
            PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
            map.from((Object)properties.getServer().getAddress()).to(factory::setAddress);
            map.from((Object)properties.getServer().getPort()).to(factory::setPort);
            map.from((Object)properties.getServer().getFragmentSize()).to(factory::setFragmentSize);
            map.from((Object)properties.getServer().getSsl()).to(factory::setSsl);
            factory.setSslBundles((SslBundles)sslBundles.getIfAvailable());
            factory.setRSocketServerCustomizers(customizers.orderedStream().toList());
            return factory;
        }

        @Bean
        @ConditionalOnMissingBean
        RSocketServerBootstrap rSocketServerBootstrap(RSocketServerFactory rSocketServerFactory, RSocketMessageHandler rSocketMessageHandler) {
            return new RSocketServerBootstrap(rSocketServerFactory, rSocketMessageHandler.responder());
        }

        @Bean
        RSocketServerCustomizer frameDecoderRSocketServerCustomizer(RSocketMessageHandler rSocketMessageHandler) {
            return server -> {
                if (rSocketMessageHandler.getRSocketStrategies().dataBufferFactory() instanceof NettyDataBufferFactory) {
                    server.payloadDecoder(PayloadDecoder.ZERO_COPY);
                }
            };
        }
    }

    @Conditional(value={OnRSocketWebServerCondition.class})
    @Configuration(proxyBeanMethods=false)
    static class WebFluxServerConfiguration {
        WebFluxServerConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        RSocketWebSocketNettyRouteProvider rSocketWebsocketRouteProvider(RSocketProperties properties, RSocketMessageHandler messageHandler, ObjectProvider<RSocketServerCustomizer> customizers) {
            String mappingPath = properties.getServer().getMappingPath();
            Assert.state((mappingPath != null ? 1 : 0) != 0, (String)"'mappingPath' must not be null");
            return new RSocketWebSocketNettyRouteProvider(mappingPath, messageHandler.responder(), this.customizeWebsocketServerSpec(properties.getServer().getSpec()), customizers.orderedStream());
        }

        private Consumer<WebsocketServerSpec.Builder> customizeWebsocketServerSpec(RSocketProperties.Server.Spec spec) {
            return builder -> {
                PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
                map.from((Object)spec.getProtocols()).to(arg_0 -> ((WebsocketServerSpec.Builder)builder).protocols(arg_0));
                map.from((Object)spec.getMaxFramePayloadLength()).asInt(DataSize::toBytes).to(arg_0 -> ((WebsocketServerSpec.Builder)builder).maxFramePayloadLength(arg_0));
                map.from((Object)spec.isHandlePing()).to(arg_0 -> ((WebsocketServerSpec.Builder)builder).handlePing(arg_0));
                map.from((Object)spec.isCompress()).to(arg_0 -> ((WebsocketServerSpec.Builder)builder).compress(arg_0));
            };
        }
    }
}

