/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.restclient;

import java.nio.charset.Charset;
import org.jspecify.annotations.Nullable;
import org.springframework.http.HttpHeaders;
import org.springframework.util.Assert;

class BasicAuthentication {
    private final String username;
    private final String password;
    private final @Nullable Charset charset;

    BasicAuthentication(String username, String password, @Nullable Charset charset) {
        Assert.notNull((Object)username, (String)"'username' must not be null");
        Assert.notNull((Object)password, (String)"'password' must not be null");
        this.username = username;
        this.password = password;
        this.charset = charset;
    }

    void applyTo(HttpHeaders headers) {
        if (!headers.containsHeader("Authorization")) {
            headers.setBasicAuth(this.username, this.password, this.charset);
        }
    }
}

