/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.r2dbc.testcontainers;

import io.r2dbc.spi.ConnectionFactoryOptions;
import org.springframework.boot.r2dbc.autoconfigure.R2dbcConnectionDetails;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionDetailsFactory;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionSource;
import org.testcontainers.mysql.MySQLContainer;
import org.testcontainers.mysql.MySQLR2DBCDatabaseContainer;

class MySqlR2dbcContainerConnectionDetailsFactory
extends ContainerConnectionDetailsFactory<MySQLContainer, R2dbcConnectionDetails> {
    MySqlR2dbcContainerConnectionDetailsFactory() {
        super(ANY_CONNECTION_NAME, new String[]{"io.r2dbc.spi.ConnectionFactoryOptions"});
    }

    public R2dbcConnectionDetails getContainerConnectionDetails(ContainerConnectionSource<MySQLContainer> source) {
        return new MySqlR2dbcDatabaseContainerConnectionDetails(source);
    }

    private static final class MySqlR2dbcDatabaseContainerConnectionDetails
    extends ContainerConnectionDetailsFactory.ContainerConnectionDetails<MySQLContainer>
    implements R2dbcConnectionDetails {
        private MySqlR2dbcDatabaseContainerConnectionDetails(ContainerConnectionSource<MySQLContainer> source) {
            super(source);
        }

        @Override
        public ConnectionFactoryOptions getConnectionFactoryOptions() {
            return MySQLR2DBCDatabaseContainer.getOptions((MySQLContainer)((MySQLContainer)this.getContainer()));
        }
    }
}

