/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.r2dbc.testcontainers;

import io.r2dbc.spi.ConnectionFactoryOptions;
import org.springframework.boot.r2dbc.autoconfigure.R2dbcConnectionDetails;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionDetailsFactory;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionSource;
import org.testcontainers.clickhouse.ClickHouseContainer;
import org.testcontainers.clickhouse.ClickHouseR2DBCDatabaseContainer;

class ClickHouseR2dbcContainerConnectionDetailsFactory
extends ContainerConnectionDetailsFactory<ClickHouseContainer, R2dbcConnectionDetails> {
    ClickHouseR2dbcContainerConnectionDetailsFactory() {
        super(ANY_CONNECTION_NAME, new String[]{"io.r2dbc.spi.ConnectionFactoryOptions"});
    }

    public R2dbcConnectionDetails getContainerConnectionDetails(ContainerConnectionSource<ClickHouseContainer> source) {
        return new ClickHouseR2dbcDatabaseContainerConnectionDetails(source);
    }

    private static final class ClickHouseR2dbcDatabaseContainerConnectionDetails
    extends ContainerConnectionDetailsFactory.ContainerConnectionDetails<ClickHouseContainer>
    implements R2dbcConnectionDetails {
        private ClickHouseR2dbcDatabaseContainerConnectionDetails(ContainerConnectionSource<ClickHouseContainer> source) {
            super(source);
        }

        @Override
        public ConnectionFactoryOptions getConnectionFactoryOptions() {
            return ClickHouseR2DBCDatabaseContainer.getOptions((ClickHouseContainer)((ClickHouseContainer)this.getContainer()));
        }
    }
}

