/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.r2dbc.docker.compose;

import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class SqlServerEnvironment {
    private final String username = "SA";
    private final String password;

    SqlServerEnvironment(Map<String, @Nullable String> env) {
        this.password = this.extractPassword(env);
    }

    private String extractPassword(Map<String, @Nullable String> env) {
        String password = env.get("MSSQL_SA_PASSWORD");
        password = password != null ? password : env.get("SA_PASSWORD");
        Assert.state((boolean)StringUtils.hasLength((String)password), (String)"No MSSQL password found");
        return password;
    }

    String getUsername() {
        return this.username;
    }

    String getPassword() {
        return this.password;
    }
}

