/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.r2dbc.docker.compose;

import io.r2dbc.spi.ConnectionFactoryOptions;
import org.springframework.boot.docker.compose.core.RunningService;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionDetailsFactory;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionSource;
import org.springframework.boot.r2dbc.autoconfigure.R2dbcConnectionDetails;
import org.springframework.boot.r2dbc.docker.compose.ConnectionFactoryOptionsBuilder;
import org.springframework.boot.r2dbc.docker.compose.OracleContainer;
import org.springframework.boot.r2dbc.docker.compose.OracleEnvironment;

abstract class OracleR2dbcDockerComposeConnectionDetailsFactory
extends DockerComposeConnectionDetailsFactory<R2dbcConnectionDetails> {
    private final String defaultDatabase;

    OracleR2dbcDockerComposeConnectionDetailsFactory(OracleContainer container) {
        super(container.getImageName(), new String[]{"io.r2dbc.spi.ConnectionFactoryOptions"});
        this.defaultDatabase = container.getDefaultDatabase();
    }

    protected R2dbcConnectionDetails getDockerComposeConnectionDetails(DockerComposeConnectionSource source) {
        return new OracleDbR2dbcDockerComposeConnectionDetails(source.getRunningService(), this.defaultDatabase);
    }

    static class OracleDbR2dbcDockerComposeConnectionDetails
    extends DockerComposeConnectionDetailsFactory.DockerComposeConnectionDetails
    implements R2dbcConnectionDetails {
        private static final ConnectionFactoryOptionsBuilder connectionFactoryOptionsBuilder = new ConnectionFactoryOptionsBuilder("oracle", 1521);
        private final ConnectionFactoryOptions connectionFactoryOptions;

        OracleDbR2dbcDockerComposeConnectionDetails(RunningService service, String defaultDatabase) {
            super(service);
            OracleEnvironment environment = new OracleEnvironment(service.env(), defaultDatabase);
            this.connectionFactoryOptions = connectionFactoryOptionsBuilder.build(service, environment.getDatabase(), environment.getUsername(), environment.getPassword());
        }

        @Override
        public ConnectionFactoryOptions getConnectionFactoryOptions() {
            return this.connectionFactoryOptions;
        }
    }
}

