/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.r2dbc.docker.compose;

import io.r2dbc.spi.ConnectionFactoryOptions;
import org.springframework.boot.docker.compose.core.RunningService;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionDetailsFactory;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionSource;
import org.springframework.boot.r2dbc.autoconfigure.R2dbcConnectionDetails;
import org.springframework.boot.r2dbc.docker.compose.ClickHouseEnvironment;
import org.springframework.boot.r2dbc.docker.compose.ConnectionFactoryOptionsBuilder;

class ClickHouseR2dbcDockerComposeConnectionDetailsFactory
extends DockerComposeConnectionDetailsFactory<R2dbcConnectionDetails> {
    private static final String[] CLICKHOUSE_CONTAINER_NAMES = new String[]{"clickhouse/clickhouse-server", "bitnami/clickhouse"};

    ClickHouseR2dbcDockerComposeConnectionDetailsFactory() {
        super(CLICKHOUSE_CONTAINER_NAMES, new String[]{"io.r2dbc.spi.ConnectionFactoryOptions"});
    }

    protected R2dbcConnectionDetails getDockerComposeConnectionDetails(DockerComposeConnectionSource source) {
        return new ClickhouseDbR2dbcDockerComposeConnectionDetails(source.getRunningService());
    }

    static class ClickhouseDbR2dbcDockerComposeConnectionDetails
    extends DockerComposeConnectionDetailsFactory.DockerComposeConnectionDetails
    implements R2dbcConnectionDetails {
        private static final ConnectionFactoryOptionsBuilder connectionFactoryOptionsBuilder = new ConnectionFactoryOptionsBuilder("clickhouse", 8123);
        private final ConnectionFactoryOptions connectionFactoryOptions;

        ClickhouseDbR2dbcDockerComposeConnectionDetails(RunningService service) {
            super(service);
            ClickHouseEnvironment environment = new ClickHouseEnvironment(service.env());
            this.connectionFactoryOptions = connectionFactoryOptionsBuilder.build(service, environment.getDatabase(), environment.getUsername(), environment.getPassword());
        }

        @Override
        public ConnectionFactoryOptions getConnectionFactoryOptions() {
            return this.connectionFactoryOptions;
        }
    }
}

