/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.r2dbc.autoconfigure;

import io.r2dbc.spi.ConnectionFactoryOptions;
import java.util.function.Supplier;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.boot.r2dbc.EmbeddedDatabaseConnection;
import org.springframework.boot.r2dbc.autoconfigure.R2dbcConnectionDetails;
import org.springframework.boot.r2dbc.autoconfigure.R2dbcProperties;
import org.springframework.util.StringUtils;

class ConnectionFactoryOptionsInitializer {
    ConnectionFactoryOptionsInitializer() {
    }

    ConnectionFactoryOptions.Builder initialize(R2dbcProperties properties, R2dbcConnectionDetails connectionDetails, Supplier<EmbeddedDatabaseConnection> embeddedDatabaseConnection) {
        if (connectionDetails != null) {
            return connectionDetails.getConnectionFactoryOptions().mutate();
        }
        EmbeddedDatabaseConnection embeddedConnection = embeddedDatabaseConnection.get();
        if (embeddedConnection != EmbeddedDatabaseConnection.NONE) {
            return this.initializeEmbeddedOptions(properties, embeddedConnection);
        }
        throw this.connectionFactoryBeanCreationException("Failed to determine a suitable R2DBC Connection URL", null, embeddedConnection);
    }

    private ConnectionFactoryOptions.Builder initializeEmbeddedOptions(R2dbcProperties properties, EmbeddedDatabaseConnection embeddedDatabaseConnection) {
        String url = embeddedDatabaseConnection.getUrl(this.determineEmbeddedDatabaseName(properties));
        if (url == null) {
            throw this.connectionFactoryBeanCreationException("Failed to determine a suitable R2DBC Connection URL", url, embeddedDatabaseConnection);
        }
        ConnectionFactoryOptions.Builder builder = ConnectionFactoryOptions.parse((CharSequence)url).mutate();
        String username = this.determineEmbeddedUsername(properties);
        if (StringUtils.hasText((String)username)) {
            builder.option(ConnectionFactoryOptions.USER, (Object)username);
        }
        if (StringUtils.hasText((String)properties.getPassword())) {
            builder.option(ConnectionFactoryOptions.PASSWORD, (Object)properties.getPassword());
        }
        return builder;
    }

    private String determineEmbeddedDatabaseName(R2dbcProperties properties) {
        String databaseName = this.determineDatabaseName(properties);
        return databaseName != null ? databaseName : "testdb";
    }

    private String determineDatabaseName(R2dbcProperties properties) {
        if (properties.isGenerateUniqueName()) {
            return properties.determineUniqueName();
        }
        if (StringUtils.hasLength((String)properties.getName())) {
            return properties.getName();
        }
        return null;
    }

    private String determineEmbeddedUsername(R2dbcProperties properties) {
        String username = this.ifHasText(properties.getUsername());
        return username != null ? username : "sa";
    }

    private ConnectionFactoryBeanCreationException connectionFactoryBeanCreationException(String message, String r2dbcUrl, EmbeddedDatabaseConnection embeddedDatabaseConnection) {
        return new ConnectionFactoryBeanCreationException(message, r2dbcUrl, embeddedDatabaseConnection);
    }

    private String ifHasText(String candidate) {
        return StringUtils.hasText((String)candidate) ? candidate : null;
    }

    static class ConnectionFactoryBeanCreationException
    extends BeanCreationException {
        private final String url;
        private final EmbeddedDatabaseConnection embeddedDatabaseConnection;

        ConnectionFactoryBeanCreationException(String message, String url, EmbeddedDatabaseConnection embeddedDatabaseConnection) {
            super(message);
            this.url = url;
            this.embeddedDatabaseConnection = embeddedDatabaseConnection;
        }

        String getUrl() {
            return this.url;
        }

        EmbeddedDatabaseConnection getEmbeddedDatabaseConnection() {
            return this.embeddedDatabaseConnection;
        }
    }
}

