/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.r2dbc.autoconfigure;

import io.r2dbc.pool.ConnectionPool;
import io.r2dbc.pool.ConnectionPoolConfiguration;
import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.ConnectionFactoryOptions;
import java.util.List;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBooleanProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.context.properties.bind.BindResult;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.r2dbc.ConnectionFactoryBuilder;
import org.springframework.boot.r2dbc.ConnectionFactoryDecorator;
import org.springframework.boot.r2dbc.EmbeddedDatabaseConnection;
import org.springframework.boot.r2dbc.autoconfigure.ConnectionFactoryOptionsBuilderCustomizer;
import org.springframework.boot.r2dbc.autoconfigure.ConnectionFactoryOptionsInitializer;
import org.springframework.boot.r2dbc.autoconfigure.MissingR2dbcPoolDependencyException;
import org.springframework.boot.r2dbc.autoconfigure.MultipleConnectionPoolConfigurationsException;
import org.springframework.boot.r2dbc.autoconfigure.R2dbcConnectionDetails;
import org.springframework.boot.r2dbc.autoconfigure.R2dbcProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

abstract class ConnectionFactoryConfigurations {
    ConnectionFactoryConfigurations() {
    }

    protected static ConnectionFactory createConnectionFactory(R2dbcProperties properties, R2dbcConnectionDetails connectionDetails, ClassLoader classLoader, List<ConnectionFactoryOptionsBuilderCustomizer> optionsCustomizers, List<ConnectionFactoryDecorator> decorators) {
        try {
            return ConnectionFactoryBuilder.withOptions(new ConnectionFactoryOptionsInitializer().initialize(properties, connectionDetails, () -> EmbeddedDatabaseConnection.get(classLoader))).configure(options -> {
                for (ConnectionFactoryOptionsBuilderCustomizer optionsCustomizer : optionsCustomizers) {
                    optionsCustomizer.customize((ConnectionFactoryOptions.Builder)options);
                }
            }).decorators(decorators).build();
        }
        catch (IllegalStateException ex) {
            String message = ex.getMessage();
            if (message != null && message.contains("driver=pool") && !ClassUtils.isPresent((String)"io.r2dbc.pool.ConnectionPool", (ClassLoader)classLoader)) {
                throw new MissingR2dbcPoolDependencyException();
            }
            throw ex;
        }
    }

    static class PooledConnectionFactoryCondition
    extends SpringBootCondition {
        PooledConnectionFactoryCondition() {
        }

        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            BindResult pool = Binder.get((Environment)context.getEnvironment()).bind("spring.r2dbc.pool", Bindable.of(R2dbcProperties.Pool.class));
            if (this.hasPoolUrl(context.getEnvironment())) {
                if (pool.isBound()) {
                    throw new MultipleConnectionPoolConfigurationsException();
                }
                return ConditionOutcome.noMatch((String)"URL-based pooling has been configured");
            }
            if (pool.isBound() && !ClassUtils.isPresent((String)"io.r2dbc.pool.ConnectionPool", (ClassLoader)context.getClassLoader())) {
                throw new MissingR2dbcPoolDependencyException();
            }
            if (((R2dbcProperties.Pool)pool.orElseGet(R2dbcProperties.Pool::new)).isEnabled()) {
                return ConditionOutcome.match((String)"Property-based pooling is enabled");
            }
            return ConditionOutcome.noMatch((String)"Property-based pooling is disabled");
        }

        private boolean hasPoolUrl(Environment environment) {
            String url = environment.getProperty("spring.r2dbc.url");
            return StringUtils.hasText((String)url) && url.contains(":pool:");
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBooleanProperty(name={"spring.r2dbc.pool.enabled"}, havingValue=false, matchIfMissing=true)
    @ConditionalOnMissingBean(value={ConnectionFactory.class})
    static class GenericConfiguration {
        GenericConfiguration() {
        }

        @Bean
        ConnectionFactory connectionFactory(R2dbcProperties properties, ObjectProvider<R2dbcConnectionDetails> connectionDetails, ResourceLoader resourceLoader, ObjectProvider<ConnectionFactoryOptionsBuilderCustomizer> customizers, ObjectProvider<ConnectionFactoryDecorator> decorators) {
            return ConnectionFactoryConfigurations.createConnectionFactory(properties, (R2dbcConnectionDetails)connectionDetails.getIfAvailable(), resourceLoader.getClassLoader(), customizers.orderedStream().toList(), decorators.orderedStream().toList());
        }
    }

    @Configuration(proxyBeanMethods=false)
    @Conditional(value={PooledConnectionFactoryCondition.class})
    @ConditionalOnMissingBean(value={ConnectionFactory.class})
    static class PoolConfiguration {
        PoolConfiguration() {
        }

        @Configuration(proxyBeanMethods=false)
        @ConditionalOnClass(value={ConnectionPool.class})
        static class PooledConnectionFactoryConfiguration {
            PooledConnectionFactoryConfiguration() {
            }

            @Bean(destroyMethod="dispose")
            ConnectionPool connectionFactory(R2dbcProperties properties, ObjectProvider<R2dbcConnectionDetails> connectionDetails, ResourceLoader resourceLoader, ObjectProvider<ConnectionFactoryOptionsBuilderCustomizer> customizers, ObjectProvider<ConnectionFactoryDecorator> decorators) {
                ConnectionFactory connectionFactory = ConnectionFactoryConfigurations.createConnectionFactory(properties, (R2dbcConnectionDetails)connectionDetails.getIfAvailable(), resourceLoader.getClassLoader(), customizers.orderedStream().toList(), decorators.orderedStream().toList());
                R2dbcProperties.Pool pool = properties.getPool();
                PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
                ConnectionPoolConfiguration.Builder builder = ConnectionPoolConfiguration.builder((ConnectionFactory)connectionFactory);
                map.from((Object)pool.getMaxIdleTime()).to(arg_0 -> ((ConnectionPoolConfiguration.Builder)builder).maxIdleTime(arg_0));
                map.from((Object)pool.getMaxLifeTime()).to(arg_0 -> ((ConnectionPoolConfiguration.Builder)builder).maxLifeTime(arg_0));
                map.from((Object)pool.getMaxAcquireTime()).to(arg_0 -> ((ConnectionPoolConfiguration.Builder)builder).maxAcquireTime(arg_0));
                map.from((Object)pool.getAcquireRetry()).to(arg_0 -> ((ConnectionPoolConfiguration.Builder)builder).acquireRetry(arg_0));
                map.from((Object)pool.getMaxCreateConnectionTime()).to(arg_0 -> ((ConnectionPoolConfiguration.Builder)builder).maxCreateConnectionTime(arg_0));
                map.from((Object)pool.getInitialSize()).to(arg_0 -> ((ConnectionPoolConfiguration.Builder)builder).initialSize(arg_0));
                map.from((Object)pool.getMaxSize()).to(arg_0 -> ((ConnectionPoolConfiguration.Builder)builder).maxSize(arg_0));
                map.from((Object)pool.getValidationQuery()).whenHasText().to(arg_0 -> ((ConnectionPoolConfiguration.Builder)builder).validationQuery(arg_0));
                map.from((Object)pool.getValidationDepth()).to(arg_0 -> ((ConnectionPoolConfiguration.Builder)builder).validationDepth(arg_0));
                map.from((Object)pool.getMinIdle()).to(arg_0 -> ((ConnectionPoolConfiguration.Builder)builder).minIdle(arg_0));
                map.from((Object)pool.getMaxValidationTime()).to(arg_0 -> ((ConnectionPoolConfiguration.Builder)builder).maxValidationTime(arg_0));
                return new ConnectionPool(builder.build());
            }
        }
    }
}

