/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.opentelemetry.testcontainers;

import org.springframework.boot.opentelemetry.autoconfigure.logging.otlp.OtlpLoggingConnectionDetails;
import org.springframework.boot.opentelemetry.autoconfigure.logging.otlp.Transport;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionDetailsFactory;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionSource;
import org.testcontainers.containers.Container;

class OtelCollectorOltpLoggingContainerConnectionDetailsFactory
extends ContainerConnectionDetailsFactory<Container<?>, OtlpLoggingConnectionDetails> {
    private static final int OTLP_GRPC_PORT = 4317;
    private static final int OTLP_HTTP_PORT = 4318;

    OtelCollectorOltpLoggingContainerConnectionDetailsFactory() {
        super("otel/opentelemetry-collector-contrib", new String[0]);
    }

    protected OtlpLoggingConnectionDetails getContainerConnectionDetails(ContainerConnectionSource<Container<?>> source) {
        return new OtlpLoggingContainerConnectionDetails(source);
    }

    private static final class OtlpLoggingContainerConnectionDetails
    extends ContainerConnectionDetailsFactory.ContainerConnectionDetails<Container<?>>
    implements OtlpLoggingConnectionDetails {
        private OtlpLoggingContainerConnectionDetails(ContainerConnectionSource<Container<?>> source) {
            super(source);
        }

        @Override
        public String getUrl(Transport transport) {
            int port = switch (transport) {
                default -> throw new IncompatibleClassChangeError();
                case Transport.HTTP -> 4318;
                case Transport.GRPC -> 4317;
            };
            return "http://%s:%d/v1/logs".formatted(this.getContainer().getHost(), this.getContainer().getMappedPort(port));
        }
    }
}

