/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.opentelemetry.testcontainers;

import org.springframework.boot.opentelemetry.autoconfigure.logging.otlp.OtlpLoggingConnectionDetails;
import org.springframework.boot.opentelemetry.autoconfigure.logging.otlp.Transport;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionDetailsFactory;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionSource;
import org.testcontainers.grafana.LgtmStackContainer;

class GrafanaOtlpLoggingContainerConnectionDetailsFactory
extends ContainerConnectionDetailsFactory<LgtmStackContainer, OtlpLoggingConnectionDetails> {
    GrafanaOtlpLoggingContainerConnectionDetailsFactory() {
        super(ANY_CONNECTION_NAME, new String[0]);
    }

    protected OtlpLoggingConnectionDetails getContainerConnectionDetails(ContainerConnectionSource<LgtmStackContainer> source) {
        return new OtlpLoggingContainerConnectionDetails(source);
    }

    private static final class OtlpLoggingContainerConnectionDetails
    extends ContainerConnectionDetailsFactory.ContainerConnectionDetails<LgtmStackContainer>
    implements OtlpLoggingConnectionDetails {
        private OtlpLoggingContainerConnectionDetails(ContainerConnectionSource<LgtmStackContainer> source) {
            super(source);
        }

        @Override
        public String getUrl(Transport transport) {
            String url = switch (transport) {
                default -> throw new IncompatibleClassChangeError();
                case Transport.HTTP -> ((LgtmStackContainer)this.getContainer()).getOtlpHttpUrl();
                case Transport.GRPC -> ((LgtmStackContainer)this.getContainer()).getOtlpGrpcUrl();
            };
            return "%s/v1/logs".formatted(url);
        }
    }
}

