/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.opentelemetry.testcontainers;

import org.springframework.boot.opentelemetry.autoconfigure.logging.OpenTelemetryLoggingConnectionDetails;
import org.springframework.boot.opentelemetry.autoconfigure.logging.Transport;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionDetailsFactory;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionSource;
import org.testcontainers.containers.Container;

class OpenTelemetryLoggingContainerConnectionDetailsFactory
extends ContainerConnectionDetailsFactory<Container<?>, OpenTelemetryLoggingConnectionDetails> {
    private static final int OTLP_GRPC_PORT = 4317;
    private static final int OTLP_HTTP_PORT = 4318;

    OpenTelemetryLoggingContainerConnectionDetailsFactory() {
        super("otel/opentelemetry-collector-contrib", new String[0]);
    }

    protected OpenTelemetryLoggingConnectionDetails getContainerConnectionDetails(ContainerConnectionSource<Container<?>> source) {
        return new OpenTelemetryLoggingContainerConnectionDetails(source);
    }

    private static final class OpenTelemetryLoggingContainerConnectionDetails
    extends ContainerConnectionDetailsFactory.ContainerConnectionDetails<Container<?>>
    implements OpenTelemetryLoggingConnectionDetails {
        private OpenTelemetryLoggingContainerConnectionDetails(ContainerConnectionSource<Container<?>> source) {
            super(source);
        }

        @Override
        public String getUrl(Transport transport) {
            int port = switch (transport) {
                default -> throw new IncompatibleClassChangeError();
                case Transport.HTTP -> 4318;
                case Transport.GRPC -> 4317;
            };
            return "http://%s:%d/v1/logs".formatted(this.getContainer().getHost(), this.getContainer().getMappedPort(port));
        }
    }
}

