/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.opentelemetry.autoconfigure.logging;

import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.opentelemetry.autoconfigure.logging.OpenTelemetryLoggingConnectionDetails;
import org.springframework.boot.opentelemetry.autoconfigure.logging.OpenTelemetryLoggingExportProperties;
import org.springframework.boot.opentelemetry.autoconfigure.logging.Transport;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.Assert;

@Configuration(proxyBeanMethods=false)
class OpenTelemetryLoggingConnectionDetailsConfiguration {
    OpenTelemetryLoggingConnectionDetailsConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"management.opentelemetry.logging.export.endpoint"})
    PropertiesOpenTelemetryLoggingConnectionDetails openTelemetryLoggingConnectionDetails(OpenTelemetryLoggingExportProperties properties) {
        return new PropertiesOpenTelemetryLoggingConnectionDetails(properties);
    }

    static class PropertiesOpenTelemetryLoggingConnectionDetails
    implements OpenTelemetryLoggingConnectionDetails {
        private final OpenTelemetryLoggingExportProperties properties;

        PropertiesOpenTelemetryLoggingConnectionDetails(OpenTelemetryLoggingExportProperties properties) {
            this.properties = properties;
        }

        @Override
        public String getUrl(Transport transport) {
            Assert.state((transport == this.properties.getTransport() ? 1 : 0) != 0, (String)"Requested transport %s doesn't match configured transport %s".formatted(new Object[]{transport, this.properties.getTransport()}));
            return this.properties.getEndpoint();
        }
    }
}

