/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.opentelemetry.autoconfigure;

import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class OpenTelemetryResourceAttributes {
    private static final String DEFAULT_SERVICE_NAME = "unknown_service";
    private final Environment environment;
    private final Map<String, String> resourceAttributes;
    private final Function<String, String> systemEnvironment;

    public OpenTelemetryResourceAttributes(Environment environment, Map<String, String> resourceAttributes) {
        this(environment, resourceAttributes, null);
    }

    OpenTelemetryResourceAttributes(Environment environment, Map<String, String> resourceAttributes, Function<String, String> systemEnvironment) {
        Assert.notNull((Object)environment, (String)"'environment' must not be null");
        this.environment = environment;
        this.resourceAttributes = resourceAttributes != null ? resourceAttributes : Collections.emptyMap();
        this.systemEnvironment = systemEnvironment != null ? systemEnvironment : System::getenv;
    }

    public void applyTo(BiConsumer<String, String> consumer) {
        Assert.notNull(consumer, (String)"'consumer' must not be null");
        Map<String, String> attributes = this.getResourceAttributesFromEnv();
        this.resourceAttributes.forEach((name, value) -> {
            if (StringUtils.hasLength((String)name) && value != null) {
                attributes.put((String)name, (String)value);
            }
        });
        attributes.computeIfAbsent("service.name", key -> this.getApplicationName());
        attributes.computeIfAbsent("service.namespace", key -> this.getServiceNamespace());
        attributes.forEach(consumer);
    }

    private String getApplicationName() {
        return this.environment.getProperty("spring.application.name", DEFAULT_SERVICE_NAME);
    }

    private String getServiceNamespace() {
        return this.environment.getProperty("spring.application.group");
    }

    private Map<String, String> getResourceAttributesFromEnv() {
        LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
        for (String attribute : StringUtils.tokenizeToStringArray((String)this.getEnv("OTEL_RESOURCE_ATTRIBUTES"), (String)",")) {
            int index = attribute.indexOf(61);
            if (index <= 0) continue;
            String key = attribute.substring(0, index);
            String value = attribute.substring(index + 1);
            attributes.put(key.trim(), OpenTelemetryResourceAttributes.decode(value.trim()));
        }
        String otelServiceName = this.getEnv("OTEL_SERVICE_NAME");
        if (otelServiceName != null) {
            attributes.put("service.name", otelServiceName);
        }
        return attributes;
    }

    private String getEnv(String name) {
        return this.systemEnvironment.apply(name);
    }

    private static String decode(String value) {
        if (value.indexOf(37) < 0) {
            return value;
        }
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        ByteArrayOutputStream out = new ByteArrayOutputStream(bytes.length);
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            if (b != 37) {
                out.write(b);
                continue;
            }
            int u = OpenTelemetryResourceAttributes.decodeHex(bytes, i + 1);
            int l = OpenTelemetryResourceAttributes.decodeHex(bytes, i + 2);
            if (u < 0 || l < 0) {
                throw new IllegalArgumentException("Failed to decode percent-encoded characters at index %d in the value: '%s'".formatted(i, value));
            }
            out.write((u << 4) + l);
            i += 2;
        }
        return out.toString(StandardCharsets.UTF_8);
    }

    private static int decodeHex(byte[] bytes, int index) {
        return index < bytes.length ? Character.digit(bytes[index], 16) : -1;
    }
}

