/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.observation.autoconfigure;

import io.micrometer.observation.GlobalObservationConvention;
import io.micrometer.observation.ObservationFilter;
import io.micrometer.observation.ObservationHandler;
import io.micrometer.observation.ObservationPredicate;
import io.micrometer.observation.ObservationRegistry;
import java.util.List;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.observation.autoconfigure.ObservationHandlerGroup;
import org.springframework.boot.observation.autoconfigure.ObservationHandlerGroups;
import org.springframework.boot.observation.autoconfigure.ObservationRegistryCustomizer;
import org.springframework.boot.util.LambdaSafe;

class ObservationRegistryConfigurer {
    private final ObjectProvider<ObservationRegistryCustomizer<?>> customizers;
    private final ObjectProvider<ObservationPredicate> observationPredicates;
    private final ObjectProvider<GlobalObservationConvention<?>> observationConventions;
    private final ObjectProvider<ObservationHandler<?>> observationHandlers;
    private final ObjectProvider<ObservationHandlerGroup> observationHandlerGroups;
    private final ObjectProvider<ObservationFilter> observationFilters;

    ObservationRegistryConfigurer(ObjectProvider<ObservationRegistryCustomizer<?>> customizers, ObjectProvider<ObservationPredicate> observationPredicates, ObjectProvider<GlobalObservationConvention<?>> observationConventions, ObjectProvider<ObservationHandler<?>> observationHandlers, ObjectProvider<ObservationHandlerGroup> observationHandlerGroups, ObjectProvider<ObservationFilter> observationFilters) {
        this.customizers = customizers;
        this.observationPredicates = observationPredicates;
        this.observationConventions = observationConventions;
        this.observationHandlers = observationHandlers;
        this.observationHandlerGroups = observationHandlerGroups;
        this.observationFilters = observationFilters;
    }

    void configure(ObservationRegistry registry) {
        this.registerObservationPredicates(registry);
        this.registerGlobalObservationConventions(registry);
        this.registerHandlers(registry);
        this.registerFilters(registry);
        this.customize(registry);
    }

    private void registerHandlers(ObservationRegistry registry) {
        ObservationHandlerGroups groups = new ObservationHandlerGroups(this.observationHandlerGroups.stream().toList());
        List<ObservationHandler<?>> orderedHandlers = this.observationHandlers.orderedStream().toList();
        groups.register(registry.observationConfig(), orderedHandlers);
    }

    private void registerObservationPredicates(ObservationRegistry registry) {
        this.observationPredicates.orderedStream().forEach(arg_0 -> ((ObservationRegistry.ObservationConfig)registry.observationConfig()).observationPredicate(arg_0));
    }

    private void registerGlobalObservationConventions(ObservationRegistry registry) {
        this.observationConventions.orderedStream().forEach(arg_0 -> ((ObservationRegistry.ObservationConfig)registry.observationConfig()).observationConvention(arg_0));
    }

    private void registerFilters(ObservationRegistry registry) {
        this.observationFilters.orderedStream().forEach(arg_0 -> ((ObservationRegistry.ObservationConfig)registry.observationConfig()).observationFilter(arg_0));
    }

    private void customize(ObservationRegistry registry) {
        ((LambdaSafe.Callbacks)LambdaSafe.callbacks(ObservationRegistryCustomizer.class, this.customizers.orderedStream().toList(), (Object)registry, (Object[])new Object[0]).withLogger(ObservationRegistryConfigurer.class)).invoke(customizer -> customizer.customize(registry));
    }
}

