/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.mustache.reactive.view;

import com.samskivert.mustache.Mustache;
import com.samskivert.mustache.Template;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.jspecify.annotations.Nullable;
import org.reactivestreams.Publisher;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.MediaType;
import org.springframework.util.Assert;
import org.springframework.web.reactive.result.view.AbstractUrlBasedView;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class MustacheView
extends AbstractUrlBasedView {
    private // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable Mustache.Compiler compiler;
    private @Nullable String charset;

    public void setCompiler(Mustache.Compiler compiler) {
        this.compiler = compiler;
    }

    public void setCharset(@Nullable String charset) {
        this.charset = charset;
    }

    public boolean checkResourceExists(Locale locale) throws Exception {
        return this.resolveResource() != null;
    }

    protected Mono<Void> renderInternal(Map<String, Object> model, @Nullable MediaType contentType, ServerWebExchange exchange) {
        Resource resource = this.resolveResource();
        if (resource == null) {
            return Mono.error((Throwable)new IllegalStateException("Could not find Mustache template with URL [" + this.getUrl() + "]"));
        }
        DataBuffer dataBuffer = exchange.getResponse().bufferFactory().allocateBuffer(256);
        try (Reader reader = this.getReader(resource);){
            Assert.state((this.compiler != null ? 1 : 0) != 0, (String)"'compiler' must not be null");
            Template template = this.compiler.compile(reader);
            Charset charset = this.getCharset(contentType).orElseGet(() -> ((MustacheView)this).getDefaultCharset());
            try (OutputStreamWriter writer = new OutputStreamWriter(dataBuffer.asOutputStream(), charset);){
                template.execute(model, (Writer)writer);
                ((Writer)writer).flush();
            }
        }
        catch (Exception ex) {
            DataBufferUtils.release((DataBuffer)dataBuffer);
            return Mono.error((Throwable)ex);
        }
        return exchange.getResponse().writeWith((Publisher)Flux.just((Object)dataBuffer));
    }

    private @Nullable Resource resolveResource() {
        ApplicationContext applicationContext = this.getApplicationContext();
        String url = this.getUrl();
        if (applicationContext == null || url == null) {
            return null;
        }
        Resource resource = applicationContext.getResource(url);
        if (resource == null || !resource.exists()) {
            return null;
        }
        return resource;
    }

    private Reader getReader(Resource resource) throws IOException {
        if (this.charset != null) {
            return new InputStreamReader(resource.getInputStream(), this.charset);
        }
        return new InputStreamReader(resource.getInputStream());
    }

    private Optional<Charset> getCharset(@Nullable MediaType mediaType) {
        return Optional.ofNullable(mediaType != null ? mediaType.getCharset() : null);
    }
}

