/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.mongodb.autoconfigure.metrics;

import com.mongodb.MongoClientSettings;
import com.mongodb.event.CommandListener;
import com.mongodb.event.ConnectionPoolListener;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.mongodb.DefaultMongoCommandTagsProvider;
import io.micrometer.core.instrument.binder.mongodb.DefaultMongoConnectionPoolTagsProvider;
import io.micrometer.core.instrument.binder.mongodb.MongoCommandTagsProvider;
import io.micrometer.core.instrument.binder.mongodb.MongoConnectionPoolTagsProvider;
import io.micrometer.core.instrument.binder.mongodb.MongoMetricsCommandListener;
import io.micrometer.core.instrument.binder.mongodb.MongoMetricsConnectionPoolListener;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBooleanProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.mongodb.autoconfigure.MongoAutoConfiguration;
import org.springframework.boot.mongodb.autoconfigure.MongoClientSettingsBuilderCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@AutoConfiguration(before={MongoAutoConfiguration.class}, afterName={"org.springframework.boot.micrometer.metrics.autoconfigure.CompositeMeterRegistryAutoConfiguration"})
@ConditionalOnClass(value={MongoClientSettings.class, MeterRegistry.class})
@ConditionalOnBean(value={MeterRegistry.class})
public final class MongoMetricsAutoConfiguration {

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={MongoMetricsConnectionPoolListener.class})
    @ConditionalOnBooleanProperty(name={"management.metrics.mongodb.connectionpool.enabled"}, matchIfMissing=true)
    static class MongoConnectionPoolMetricsConfiguration {
        MongoConnectionPoolMetricsConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        MongoMetricsConnectionPoolListener mongoMetricsConnectionPoolListener(MeterRegistry meterRegistry, MongoConnectionPoolTagsProvider mongoConnectionPoolTagsProvider) {
            return new MongoMetricsConnectionPoolListener(meterRegistry, mongoConnectionPoolTagsProvider);
        }

        @Bean
        @ConditionalOnMissingBean
        MongoConnectionPoolTagsProvider mongoConnectionPoolTagsProvider() {
            return new DefaultMongoConnectionPoolTagsProvider();
        }

        @Bean
        MongoClientSettingsBuilderCustomizer mongoMetricsConnectionPoolListenerClientSettingsBuilderCustomizer(MongoMetricsConnectionPoolListener mongoMetricsConnectionPoolListener) {
            return clientSettingsBuilder -> clientSettingsBuilder.applyToConnectionPoolSettings(connectionPoolSettingsBuilder -> connectionPoolSettingsBuilder.addConnectionPoolListener((ConnectionPoolListener)mongoMetricsConnectionPoolListener));
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={MongoMetricsCommandListener.class})
    @ConditionalOnBooleanProperty(name={"management.metrics.mongodb.command.enabled"}, matchIfMissing=true)
    static class MongoCommandMetricsConfiguration {
        MongoCommandMetricsConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        MongoMetricsCommandListener mongoMetricsCommandListener(MeterRegistry meterRegistry, MongoCommandTagsProvider mongoCommandTagsProvider) {
            return new MongoMetricsCommandListener(meterRegistry, mongoCommandTagsProvider);
        }

        @Bean
        @ConditionalOnMissingBean
        MongoCommandTagsProvider mongoCommandTagsProvider() {
            return new DefaultMongoCommandTagsProvider();
        }

        @Bean
        MongoClientSettingsBuilderCustomizer mongoMetricsCommandListenerClientSettingsBuilderCustomizer(MongoMetricsCommandListener mongoMetricsCommandListener) {
            return clientSettingsBuilder -> clientSettingsBuilder.addCommandListener((CommandListener)mongoMetricsCommandListener);
        }
    }
}

