/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.micrometer.tracing.autoconfigure;

import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.micrometer.tracing.autoconfigure.ConditionalOnEnabledTracingExport;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.StringUtils;

class OnEnabledTracingExportCondition
extends SpringBootCondition {
    private static final String GLOBAL_PROPERTY = "management.tracing.export.enabled";
    private static final String EXPORTER_PROPERTY = "management.tracing.export.%s.enabled";

    OnEnabledTracingExportCondition() {
    }

    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        Boolean exporterTracingEnabled;
        String tracingExporter = OnEnabledTracingExportCondition.getExporterName(metadata);
        if (StringUtils.hasLength((String)tracingExporter) && (exporterTracingEnabled = (Boolean)context.getEnvironment().getProperty(EXPORTER_PROPERTY.formatted(tracingExporter), Boolean.class)) != null) {
            return new ConditionOutcome(exporterTracingEnabled.booleanValue(), ConditionMessage.forCondition(ConditionalOnEnabledTracingExport.class, (Object[])new Object[0]).because(EXPORTER_PROPERTY.formatted(tracingExporter) + " is " + exporterTracingEnabled));
        }
        Boolean globalTracingEnabled = (Boolean)context.getEnvironment().getProperty(GLOBAL_PROPERTY, Boolean.class);
        if (globalTracingEnabled != null) {
            return new ConditionOutcome(globalTracingEnabled.booleanValue(), ConditionMessage.forCondition(ConditionalOnEnabledTracingExport.class, (Object[])new Object[0]).because("management.tracing.export.enabled is " + globalTracingEnabled));
        }
        return ConditionOutcome.match((ConditionMessage)ConditionMessage.forCondition(ConditionalOnEnabledTracingExport.class, (Object[])new Object[0]).because("tracing is enabled by default"));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static @Nullable String getExporterName(AnnotatedTypeMetadata metadata) {
        @Nullable Map attributes = metadata.getAnnotationAttributes(ConditionalOnEnabledTracingExport.class.getName());
        if (attributes == null) {
            return null;
        }
        return (String)attributes.get("value");
    }
}

