/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.micrometer.tracing.brave.autoconfigure;

import brave.baggage.BaggageField;
import brave.baggage.BaggagePropagation;
import brave.baggage.BaggagePropagationConfig;
import brave.baggage.BaggagePropagationCustomizer;
import brave.baggage.CorrelationScopeConfig;
import brave.baggage.CorrelationScopeCustomizer;
import brave.baggage.CorrelationScopeDecorator;
import brave.context.slf4j.MDCScopeDecorator;
import brave.propagation.CurrentTraceContext;
import brave.propagation.Propagation;
import io.micrometer.tracing.BaggageManager;
import io.micrometer.tracing.brave.bridge.BraveBaggageManager;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBooleanProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.micrometer.tracing.autoconfigure.ConditionalOnEnabledTracingExport;
import org.springframework.boot.micrometer.tracing.autoconfigure.TracingProperties;
import org.springframework.boot.micrometer.tracing.brave.autoconfigure.CompositePropagationFactory;
import org.springframework.boot.micrometer.tracing.brave.autoconfigure.LocalBaggageFields;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

class BravePropagationConfigurations {
    BravePropagationConfigurations() {
    }

    @Configuration(proxyBeanMethods=false)
    static class NoPropagation {
        NoPropagation() {
        }

        @Bean
        @ConditionalOnMissingBean(value={Propagation.Factory.class})
        CompositePropagationFactory noopPropagationFactory() {
            return CompositePropagationFactory.noop();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBooleanProperty(name={"management.tracing.baggage.enabled"}, matchIfMissing=true)
    @EnableConfigurationProperties(value={TracingProperties.class})
    static class PropagationWithBaggage {
        private final TracingProperties tracingProperties;

        PropagationWithBaggage(TracingProperties tracingProperties) {
            this.tracingProperties = tracingProperties;
        }

        @Bean
        @ConditionalOnMissingBean
        BaggagePropagation.FactoryBuilder propagationFactoryBuilder(ObjectProvider<BaggagePropagationCustomizer> baggagePropagationCustomizers) {
            BaggagePropagation.FactoryBuilder throwAwayBuilder = BaggagePropagation.newFactoryBuilder((Propagation.Factory)this.createThrowAwayFactory());
            baggagePropagationCustomizers.orderedStream().forEach(customizer -> customizer.customize(throwAwayBuilder));
            CompositePropagationFactory propagationFactory = CompositePropagationFactory.create(this.tracingProperties.getPropagation(), (BaggageManager)new BraveBaggageManager(this.tracingProperties.getBaggage().getTagFields(), this.tracingProperties.getBaggage().getRemoteFields()), LocalBaggageFields.extractFrom(throwAwayBuilder));
            BaggagePropagation.FactoryBuilder builder = BaggagePropagation.newFactoryBuilder((Propagation.Factory)propagationFactory);
            throwAwayBuilder.configs().forEach(arg_0 -> ((BaggagePropagation.FactoryBuilder)builder).add(arg_0));
            return builder;
        }

        private Propagation.Factory createThrowAwayFactory() {
            return new Propagation.Factory(){

                public @Nullable Propagation<String> get() {
                    return null;
                }
            };
        }

        @Bean
        BaggagePropagationCustomizer remoteFieldsBaggagePropagationCustomizer() {
            return builder -> {
                List remoteFields = this.tracingProperties.getBaggage().getRemoteFields();
                for (String fieldName : remoteFields) {
                    builder.add((BaggagePropagationConfig)BaggagePropagationConfig.SingleBaggageField.remote((BaggageField)BaggageField.create((String)fieldName)));
                }
                List localFields = this.tracingProperties.getBaggage().getLocalFields();
                for (String localFieldName : localFields) {
                    builder.add((BaggagePropagationConfig)BaggagePropagationConfig.SingleBaggageField.local((BaggageField)BaggageField.create((String)localFieldName)));
                }
            };
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnEnabledTracingExport
        Propagation.Factory propagationFactory(BaggagePropagation.FactoryBuilder factoryBuilder) {
            return factoryBuilder.build();
        }

        @Bean
        @ConditionalOnMissingBean
        CorrelationScopeDecorator.Builder mdcCorrelationScopeDecoratorBuilder(ObjectProvider<CorrelationScopeCustomizer> correlationScopeCustomizers) {
            CorrelationScopeDecorator.Builder builder = MDCScopeDecorator.newBuilder();
            correlationScopeCustomizers.orderedStream().forEach(customizer -> customizer.customize(builder));
            return builder;
        }

        @Bean
        @Order(value=0)
        @ConditionalOnBooleanProperty(name={"management.tracing.baggage.correlation.enabled"}, matchIfMissing=true)
        CorrelationScopeCustomizer correlationFieldsCorrelationScopeCustomizer() {
            return builder -> {
                TracingProperties.Baggage.Correlation correlationProperties = this.tracingProperties.getBaggage().getCorrelation();
                for (String field : correlationProperties.getFields()) {
                    BaggageField baggageField = BaggageField.create((String)field);
                    CorrelationScopeConfig.SingleCorrelationField correlationField = CorrelationScopeConfig.SingleCorrelationField.newBuilder((BaggageField)baggageField).flushOnUpdate().build();
                    builder.add((CorrelationScopeConfig)correlationField);
                }
            };
        }

        @Bean
        @ConditionalOnMissingBean(value={CorrelationScopeDecorator.class})
        CurrentTraceContext.ScopeDecorator correlationScopeDecorator(CorrelationScopeDecorator.Builder builder) {
            return builder.build();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBooleanProperty(name={"management.tracing.baggage.enabled"}, havingValue=false)
    static class PropagationWithoutBaggage {
        PropagationWithoutBaggage() {
        }

        @Bean
        @ConditionalOnMissingBean(value={Propagation.Factory.class})
        @ConditionalOnEnabledTracingExport
        CompositePropagationFactory propagationFactory(TracingProperties properties) {
            return CompositePropagationFactory.create(properties.getPropagation());
        }
    }
}

