/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.micrometer.observation.autoconfigure;

import io.micrometer.common.annotation.ValueExpressionResolver;
import io.micrometer.observation.GlobalObservationConvention;
import io.micrometer.observation.ObservationFilter;
import io.micrometer.observation.ObservationHandler;
import io.micrometer.observation.ObservationPredicate;
import io.micrometer.observation.ObservationRegistry;
import io.micrometer.observation.aop.ObservedAspect;
import org.aspectj.weaver.Advice;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBooleanProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.micrometer.observation.autoconfigure.ObservationHandlerGroup;
import org.springframework.boot.micrometer.observation.autoconfigure.ObservationProperties;
import org.springframework.boot.micrometer.observation.autoconfigure.ObservationRegistryCustomizer;
import org.springframework.boot.micrometer.observation.autoconfigure.ObservationRegistryPostProcessor;
import org.springframework.boot.micrometer.observation.autoconfigure.PropertiesObservationFilterPredicate;
import org.springframework.boot.micrometer.observation.autoconfigure.SpelValueExpressionResolver;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

@AutoConfiguration
@ConditionalOnClass(value={ObservationRegistry.class})
@EnableConfigurationProperties(value={ObservationProperties.class})
public final class ObservationAutoConfiguration {
    @Bean
    static ObservationRegistryPostProcessor observationRegistryPostProcessor(ObjectProvider<ObservationRegistryCustomizer<?>> observationRegistryCustomizers, ObjectProvider<ObservationPredicate> observationPredicates, ObjectProvider<GlobalObservationConvention<?>> observationConventions, ObjectProvider<ObservationHandler<?>> observationHandlers, ObjectProvider<ObservationHandlerGroup> observationHandlerGroups, ObjectProvider<ObservationFilter> observationFilters) {
        return new ObservationRegistryPostProcessor(observationRegistryCustomizers, observationPredicates, observationConventions, observationHandlers, observationHandlerGroups, observationFilters);
    }

    @Bean
    @ConditionalOnMissingBean
    ObservationRegistry observationRegistry() {
        return ObservationRegistry.create();
    }

    @Bean
    @Order(value=0)
    PropertiesObservationFilterPredicate propertiesObservationFilter(ObservationProperties properties) {
        return new PropertiesObservationFilterPredicate(properties);
    }

    @Bean
    @ConditionalOnMissingBean(value={ValueExpressionResolver.class})
    SpelValueExpressionResolver spelValueExpressionResolver() {
        return new SpelValueExpressionResolver();
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={Advice.class})
    @ConditionalOnBooleanProperty(value={"management.observations.annotations.enabled"})
    static class ObservedAspectConfiguration {
        ObservedAspectConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        ObservedAspect observedAspect(ObservationRegistry observationRegistry) {
            return new ObservedAspect(observationRegistry);
        }
    }
}

