/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.micrometer.observation.autoconfigure;

import io.micrometer.observation.GlobalObservationConvention;
import io.micrometer.observation.ObservationFilter;
import io.micrometer.observation.ObservationHandler;
import io.micrometer.observation.ObservationPredicate;
import io.micrometer.observation.ObservationRegistry;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.micrometer.observation.autoconfigure.ObservationHandlerGroup;
import org.springframework.boot.micrometer.observation.autoconfigure.ObservationRegistryConfigurer;
import org.springframework.boot.micrometer.observation.autoconfigure.ObservationRegistryCustomizer;

class ObservationRegistryPostProcessor
implements BeanPostProcessor {
    private final ObjectProvider<ObservationRegistryCustomizer<?>> observationRegistryCustomizers;
    private final ObjectProvider<ObservationPredicate> observationPredicates;
    private final ObjectProvider<GlobalObservationConvention<?>> observationConventions;
    private final ObjectProvider<ObservationHandler<?>> observationHandlers;
    private final ObjectProvider<ObservationHandlerGroup> observationHandlerGroups;
    private final ObjectProvider<ObservationFilter> observationFilters;
    private volatile @Nullable ObservationRegistryConfigurer configurer;

    ObservationRegistryPostProcessor(ObjectProvider<ObservationRegistryCustomizer<?>> observationRegistryCustomizers, ObjectProvider<ObservationPredicate> observationPredicates, ObjectProvider<GlobalObservationConvention<?>> observationConventions, ObjectProvider<ObservationHandler<?>> observationHandlers, ObjectProvider<ObservationHandlerGroup> observationHandlerGroups, ObjectProvider<ObservationFilter> observationFilters) {
        this.observationRegistryCustomizers = observationRegistryCustomizers;
        this.observationPredicates = observationPredicates;
        this.observationConventions = observationConventions;
        this.observationHandlers = observationHandlers;
        this.observationHandlerGroups = observationHandlerGroups;
        this.observationFilters = observationFilters;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof ObservationRegistry) {
            ObservationRegistry registry = (ObservationRegistry)bean;
            this.getConfigurer().configure(registry);
        }
        return bean;
    }

    private ObservationRegistryConfigurer getConfigurer() {
        if (this.configurer == null) {
            this.configurer = new ObservationRegistryConfigurer(this.observationRegistryCustomizers, this.observationPredicates, this.observationConventions, this.observationHandlers, this.observationHandlerGroups, this.observationFilters);
        }
        return this.configurer;
    }
}

