/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.micrometer.metrics.autoconfigure.export.statsd;

import io.micrometer.core.instrument.Clock;
import io.micrometer.statsd.StatsdConfig;
import io.micrometer.statsd.StatsdMeterRegistry;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.micrometer.metrics.autoconfigure.CompositeMeterRegistryAutoConfiguration;
import org.springframework.boot.micrometer.metrics.autoconfigure.MetricsAutoConfiguration;
import org.springframework.boot.micrometer.metrics.autoconfigure.export.ConditionalOnEnabledMetricsExport;
import org.springframework.boot.micrometer.metrics.autoconfigure.export.simple.SimpleMetricsExportAutoConfiguration;
import org.springframework.boot.micrometer.metrics.autoconfigure.export.statsd.StatsdProperties;
import org.springframework.boot.micrometer.metrics.autoconfigure.export.statsd.StatsdPropertiesConfigAdapter;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(before={CompositeMeterRegistryAutoConfiguration.class, SimpleMetricsExportAutoConfiguration.class}, after={MetricsAutoConfiguration.class})
@ConditionalOnBean(value={Clock.class})
@ConditionalOnClass(value={StatsdMeterRegistry.class})
@ConditionalOnEnabledMetricsExport(value="statsd")
@EnableConfigurationProperties(value={StatsdProperties.class})
public final class StatsdMetricsExportAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    StatsdConfig statsdConfig(StatsdProperties statsdProperties) {
        return new StatsdPropertiesConfigAdapter(statsdProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    StatsdMeterRegistry statsdMeterRegistry(StatsdConfig statsdConfig, Clock clock) {
        return new StatsdMeterRegistry(statsdConfig, clock);
    }
}

