/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.micrometer.metrics.autoconfigure.export.stackdriver;

import io.micrometer.core.instrument.Clock;
import io.micrometer.stackdriver.StackdriverConfig;
import io.micrometer.stackdriver.StackdriverMeterRegistry;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.micrometer.metrics.autoconfigure.CompositeMeterRegistryAutoConfiguration;
import org.springframework.boot.micrometer.metrics.autoconfigure.MetricsAutoConfiguration;
import org.springframework.boot.micrometer.metrics.autoconfigure.export.ConditionalOnEnabledMetricsExport;
import org.springframework.boot.micrometer.metrics.autoconfigure.export.simple.SimpleMetricsExportAutoConfiguration;
import org.springframework.boot.micrometer.metrics.autoconfigure.export.stackdriver.StackdriverProperties;
import org.springframework.boot.micrometer.metrics.autoconfigure.export.stackdriver.StackdriverPropertiesConfigAdapter;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(before={CompositeMeterRegistryAutoConfiguration.class, SimpleMetricsExportAutoConfiguration.class}, after={MetricsAutoConfiguration.class})
@ConditionalOnBean(value={Clock.class})
@ConditionalOnClass(value={StackdriverMeterRegistry.class})
@ConditionalOnEnabledMetricsExport(value="stackdriver")
@EnableConfigurationProperties(value={StackdriverProperties.class})
public final class StackdriverMetricsExportAutoConfiguration {
    private final StackdriverProperties properties;

    StackdriverMetricsExportAutoConfiguration(StackdriverProperties stackdriverProperties) {
        this.properties = stackdriverProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    StackdriverConfig stackdriverConfig() {
        return new StackdriverPropertiesConfigAdapter(this.properties);
    }

    @Bean
    @ConditionalOnMissingBean
    StackdriverMeterRegistry stackdriverMeterRegistry(StackdriverConfig stackdriverConfig, Clock clock) {
        return StackdriverMeterRegistry.builder((StackdriverConfig)stackdriverConfig).clock(clock).build();
    }
}

