/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.maven;

import java.io.File;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ResolutionErrorHandler;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.shared.artifact.filter.collection.ArtifactsFilter;
import org.springframework.boot.maven.AbstractAotMojo;
import org.springframework.boot.maven.AbstractDependencyFilterMojo;

@Mojo(name="process-test-aot", defaultPhase=LifecyclePhase.PROCESS_TEST_CLASSES, threadSafe=true, requiresDependencyResolution=ResolutionScope.TEST, requiresDependencyCollection=ResolutionScope.TEST)
public class ProcessTestAotMojo
extends AbstractAotMojo {
    private static final String JUNIT_PLATFORM_GROUP_ID = "org.junit.platform";
    private static final String JUNIT_PLATFORM_COMMONS_ARTIFACT_ID = "junit-platform-commons";
    private static final String JUNIT_PLATFORM_LAUNCHER_ARTIFACT_ID = "junit-platform-launcher";
    private static final String AOT_PROCESSOR_CLASS_NAME = "org.springframework.test.context.aot.TestAotProcessor";
    @Parameter(defaultValue="${project.build.testOutputDirectory}", required=true)
    private File testClassesDirectory;
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true)
    private File classesDirectory;
    @Parameter(defaultValue="${project.build.directory}/spring-aot/test/sources", required=true)
    private File generatedSources;
    @Parameter(defaultValue="${project.build.directory}/spring-aot/test/resources", required=true)
    private File generatedResources;
    @Parameter(defaultValue="${project.build.directory}/spring-aot/test/classes", required=true)
    private File generatedTestClasses;
    @Parameter(defaultValue="${project.build.directory}/spring-aot/main/classes", required=true)
    private File generatedClasses;
    @Parameter(defaultValue="${localRepository}", required=true, readonly=true)
    private ArtifactRepository localRepository;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", required=true, readonly=true)
    private List<ArtifactRepository> remoteRepositories;
    @Component
    private RepositorySystem repositorySystem;
    @Component
    private ResolutionErrorHandler resolutionErrorHandler;

    @Override
    protected void executeAot() throws Exception {
        if (Boolean.getBoolean("skipTests") || Boolean.getBoolean("maven.test.skip")) {
            this.getLog().info((CharSequence)"Skipping AOT test processing since tests are skipped");
            return;
        }
        Path testOutputDirectory = Paths.get(this.project.getBuild().getTestOutputDirectory(), new String[0]);
        if (Files.notExists(testOutputDirectory, new LinkOption[0])) {
            this.getLog().info((CharSequence)"Skipping AOT test processing since no tests have been detected");
            return;
        }
        this.generateAotAssets(this.getClassPath(true), AOT_PROCESSOR_CLASS_NAME, this.getAotArguments());
        this.compileSourceFiles(this.getClassPath(false), this.generatedSources, this.testClassesDirectory);
        this.copyAll(this.generatedResources.toPath().resolve("META-INF/native-image"), this.testClassesDirectory.toPath().resolve("META-INF/native-image"));
        this.copyAll(this.generatedTestClasses.toPath(), this.testClassesDirectory.toPath());
    }

    private String[] getAotArguments() {
        ArrayList<String> aotArguments = new ArrayList<String>();
        aotArguments.add(this.testClassesDirectory.toPath().toAbsolutePath().normalize().toString());
        aotArguments.add(this.generatedSources.toString());
        aotArguments.add(this.generatedResources.toString());
        aotArguments.add(this.generatedTestClasses.toString());
        aotArguments.add(this.project.getGroupId());
        aotArguments.add(this.project.getArtifactId());
        return (String[])aotArguments.toArray(String[]::new);
    }

    protected URL[] getClassPath(boolean includeJUnitPlatformLauncher) throws Exception {
        File[] directories = new File[]{this.testClassesDirectory, this.generatedTestClasses, this.classesDirectory, this.generatedClasses};
        URL[] classPath = this.getClassPath(directories, new ArtifactsFilter[0]);
        if (!includeJUnitPlatformLauncher || this.project.getArtifactMap().containsKey("org.junit.platform:junit-platform-launcher")) {
            return classPath;
        }
        return this.addJUnitPlatformLauncher(classPath);
    }

    private URL[] addJUnitPlatformLauncher(URL[] classPath) throws Exception {
        String version = this.getJUnitPlatformVersion();
        DefaultArtifactHandler handler = new DefaultArtifactHandler("jar");
        handler.setIncludesDependencies(true);
        ArtifactResolutionResult resolutionResult = this.resolveArtifact((Artifact)new DefaultArtifact(JUNIT_PLATFORM_GROUP_ID, JUNIT_PLATFORM_LAUNCHER_ARTIFACT_ID, version, null, "jar", null, (ArtifactHandler)handler));
        LinkedHashSet<URL> fullClassPath = new LinkedHashSet<URL>(Arrays.asList(classPath));
        for (Artifact artifact : resolutionResult.getArtifacts()) {
            fullClassPath.add(artifact.getFile().toURI().toURL());
        }
        return (URL[])fullClassPath.toArray(URL[]::new);
    }

    private String getJUnitPlatformVersion() throws MojoExecutionException {
        String version;
        String id = "org.junit.platform:junit-platform-commons";
        Artifact platformCommonsArtifact = (Artifact)this.project.getArtifactMap().get(id);
        String string = version = platformCommonsArtifact != null ? platformCommonsArtifact.getBaseVersion() : null;
        if (version == null) {
            throw new MojoExecutionException("Unable to find '%s' dependnecy. Please ensure JUnit is correctly configured.".formatted(id));
        }
        return version;
    }

    private ArtifactResolutionResult resolveArtifact(Artifact artifact) throws Exception {
        ArtifactResolutionRequest request = new ArtifactResolutionRequest();
        request.setArtifact(artifact);
        request.setLocalRepository(this.localRepository);
        request.setResolveTransitively(true);
        request.setCollectionFilter((ArtifactFilter)new AbstractDependencyFilterMojo.RuntimeArtifactFilter());
        request.setRemoteRepositories(this.remoteRepositories);
        ArtifactResolutionResult result = this.repositorySystem.resolve(request);
        this.resolutionErrorHandler.throwErrors(request, result);
        return result;
    }
}

