/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.maven;

import java.io.File;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.springframework.boot.loader.tools.RunProcess;
import org.springframework.boot.maven.AbstractApplicationRunMojo;
import org.springframework.boot.maven.RunArguments;

@Mojo(name="run", requiresProject=true, defaultPhase=LifecyclePhase.VALIDATE, requiresDependencyResolution=ResolutionScope.TEST)
@Execute(phase=LifecyclePhase.TEST_COMPILE)
public class RunMojo
extends AbstractApplicationRunMojo {
    @Parameter(property="spring-boot.run.optimizedLaunch", defaultValue="true")
    private boolean optimizedLaunch;

    @Override
    protected RunArguments resolveJvmArguments() {
        RunArguments jvmArguments = super.resolveJvmArguments();
        if (this.optimizedLaunch) {
            jvmArguments.getArgs().addFirst("-XX:TieredStopAtLevel=1");
            if (!this.isJava13OrLater()) {
                jvmArguments.getArgs().addFirst("-Xverify:none");
            }
        }
        return jvmArguments;
    }

    private boolean isJava13OrLater() {
        for (Method method : String.class.getMethods()) {
            if (!method.getName().equals("stripIndent")) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void run(File workingDirectory, List<String> args, Map<String, String> environmentVariables) throws MojoExecutionException {
        int exitCode = this.forkJvm(workingDirectory, args, environmentVariables);
        if (this.hasTerminatedSuccessfully(exitCode)) {
            return;
        }
        throw new MojoExecutionException("Application finished with exit code: " + exitCode);
    }

    private int forkJvm(File workingDirectory, List<String> args, Map<String, String> environmentVariables) throws MojoExecutionException {
        try {
            RunProcess runProcess = new RunProcess(workingDirectory, new String[]{this.getJavaExecutable()});
            Runtime.getRuntime().addShutdownHook(new Thread(new RunProcessKiller(runProcess)));
            return runProcess.run(true, args, environmentVariables);
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Could not exec java", ex);
        }
    }

    private static final class RunProcessKiller
    implements Runnable {
        private final RunProcess runProcess;

        private RunProcessKiller(RunProcess runProcess) {
            this.runProcess = runProcess;
        }

        @Override
        public void run() {
            this.runProcess.kill();
        }
    }
}

