/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.maven;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.shared.artifact.filter.collection.ArtifactsFilter;
import org.springframework.boot.loader.tools.RunProcess;
import org.springframework.boot.maven.AbstractRunMojo;

@Mojo(name="aot-generate", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class AotGenerateMojo
extends AbstractRunMojo {
    private static final String AOT_PROCESSOR_CLASS_NAME = "org.springframework.boot.AotProcessor";
    @Parameter(defaultValue="${project.build.directory}/spring-aot/main/sources", required=true)
    private File generatedSources;
    @Parameter(defaultValue="${project.build.directory}/spring-aot/main/resources", required=true)
    private File generatedResources;
    @Parameter(defaultValue="${project.build.directory}/spring-aot/main/classes", required=true)
    private File generatedClasses;

    @Override
    protected void run(File workingDirectory, String startClassName, Map<String, String> environmentVariables) throws MojoExecutionException, MojoFailureException {
        try {
            this.generateAotAssets(workingDirectory, startClassName, environmentVariables);
            this.compileSourceFiles();
            this.copyNativeConfiguration(this.generatedResources.toPath());
        }
        catch (Exception ex) {
            throw new MojoExecutionException(ex.getMessage(), ex);
        }
    }

    private void generateAotAssets(File workingDirectory, String startClassName, Map<String, String> environmentVariables) throws MojoExecutionException {
        int exitCode;
        ArrayList<String> args = new ArrayList<String>();
        this.addJvmArgs(args);
        this.addClasspath(args);
        args.add(AOT_PROCESSOR_CLASS_NAME);
        args.add(startClassName);
        args.add(this.generatedSources.toString());
        args.add(this.generatedResources.toString());
        args.add(this.generatedClasses.toString());
        args.add(this.project.getGroupId());
        args.add(this.project.getArtifactId());
        this.addArgs(args);
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Generating AOT assets using command: " + args));
        }
        if (!this.hasTerminatedSuccessfully(exitCode = this.forkJvm(workingDirectory, args, environmentVariables))) {
            throw new MojoExecutionException("AOT generation process finished with exit code: " + exitCode);
        }
    }

    private int forkJvm(File workingDirectory, List<String> args, Map<String, String> environmentVariables) throws MojoExecutionException {
        try {
            RunProcess runProcess = new RunProcess(workingDirectory, new String[]{this.getJavaExecutable()});
            return runProcess.run(true, args, environmentVariables);
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Could not exec java", ex);
        }
    }

    @Override
    protected URL[] getClassPathUrls() throws MojoExecutionException {
        try {
            ArrayList<URL> urls = new ArrayList<URL>();
            this.addUserDefinedDirectories(urls);
            this.addProjectClasses(urls);
            this.addDependencies(urls, this.getFilters(new ArtifactsFilter[]{new AbstractRunMojo.TestArtifactFilter()}));
            return urls.toArray(new URL[0]);
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Unable to build classpath", (Exception)ex);
        }
    }

    private void compileSourceFiles() throws IOException, MojoExecutionException {
        List<Path> sourceFiles = Files.walk(this.generatedSources.toPath(), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).toList();
        if (sourceFiles.isEmpty()) {
            return;
        }
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        try (StandardJavaFileManager fm = compiler.getStandardFileManager(null, null, null);){
            ArrayList<String> options = new ArrayList<String>();
            this.addClasspath(options);
            options.add("-d");
            options.add(this.classesDirectory.toPath().toAbsolutePath().toString());
            Iterable<? extends JavaFileObject> compilationUnits = fm.getJavaFileObjectsFromPaths((Collection<? extends Path>)sourceFiles);
            Errors errors = new Errors();
            JavaCompiler.CompilationTask task = compiler.getTask(null, fm, errors, options, null, compilationUnits);
            boolean result = task.call();
            if (!result || errors.hasReportedErrors()) {
                throw new IllegalStateException("Unable to compile generated source" + errors);
            }
        }
    }

    private void copyNativeConfiguration(Path generatedResources) throws IOException {
        Path targetDirectory = this.classesDirectory.toPath().resolve("META-INF/native-image");
        Path sourceDirectory = generatedResources.resolve("META-INF/native-image");
        List<Path> files = Files.walk(sourceDirectory, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).toList();
        for (Path file : files) {
            String relativeFileName = file.subpath(sourceDirectory.getNameCount(), file.getNameCount()).toString();
            this.getLog().debug((CharSequence)("Copying '" + relativeFileName + "' to " + targetDirectory));
            Path target = targetDirectory.resolve(relativeFileName);
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
            Files.copy(file, target, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    static class Errors
    implements DiagnosticListener<JavaFileObject> {
        private final StringBuilder message = new StringBuilder();

        Errors() {
        }

        @Override
        public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
            if (diagnostic.getKind() == Diagnostic.Kind.ERROR) {
                this.message.append("\n");
                this.message.append(diagnostic.getMessage(Locale.getDefault()));
                this.message.append(" ");
                this.message.append(diagnostic.getSource().getName());
                this.message.append(" ");
                this.message.append(diagnostic.getLineNumber()).append(":").append(diagnostic.getColumnNumber());
            }
        }

        boolean hasReportedErrors() {
            return this.message.length() > 0;
        }

        public String toString() {
            return this.message.toString();
        }
    }
}

