/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.maven;

import org.springframework.boot.buildpack.platform.docker.configuration.DockerConfiguration;

public class Docker {
    private DockerRegistry registry;

    public void setRegistry(DockerRegistry registry) {
        this.registry = registry;
    }

    DockerConfiguration asDockerConfiguration() {
        if (this.registry == null || this.registry.isEmpty()) {
            return null;
        }
        if (this.registry.hasTokenAuth() && !this.registry.hasUserAuth()) {
            return DockerConfiguration.withRegistryTokenAuthentication((String)this.registry.getToken());
        }
        if (this.registry.hasUserAuth() && !this.registry.hasTokenAuth()) {
            return DockerConfiguration.withRegistryUserAuthentication((String)this.registry.getUsername(), (String)this.registry.getPassword(), (String)this.registry.getUrl(), (String)this.registry.getEmail());
        }
        throw new IllegalArgumentException("Invalid Docker registry configuration, either token or username/password must be provided");
    }

    public static class DockerRegistry {
        private String username;
        private String password;
        private String url;
        private String email;
        private String token;

        String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        String getEmail() {
            return this.email;
        }

        public void setEmail(String email) {
            this.email = email;
        }

        String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        String getToken() {
            return this.token;
        }

        public void setToken(String token) {
            this.token = token;
        }

        boolean isEmpty() {
            return this.username == null && this.password == null && this.url == null && this.email == null && this.token == null;
        }

        boolean hasTokenAuth() {
            return this.token != null;
        }

        boolean hasUserAuth() {
            return this.username != null && this.password != null;
        }
    }
}

