/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.maven;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.springframework.boot.loader.tools.JavaExecutable;
import org.springframework.boot.loader.tools.RunProcess;
import org.springframework.boot.maven.AbstractRunMojo;

@Mojo(name="run", requiresProject=true, defaultPhase=LifecyclePhase.VALIDATE, requiresDependencyResolution=ResolutionScope.TEST)
@Execute(phase=LifecyclePhase.TEST_COMPILE)
public class RunMojo
extends AbstractRunMojo {
    private static final int EXIT_CODE_SIGINT = 130;
    private static final String RESTARTER_CLASS_LOCATION = "org/springframework/boot/devtools/restart/Restarter.class";
    private Boolean hasDevtools;

    @Override
    protected boolean enableForkByDefault() {
        return super.enableForkByDefault() || this.hasDevtools();
    }

    @Override
    protected void logDisabledFork() {
        super.logDisabledFork();
        if (this.hasDevtools()) {
            this.getLog().warn((CharSequence)"Fork mode disabled, devtools will be disabled");
        }
    }

    @Override
    protected void runWithForkedJvm(File workingDirectory, List<String> args, Map<String, String> environmentVariables) throws MojoExecutionException {
        try {
            RunProcess runProcess = new RunProcess(workingDirectory, new String[]{new JavaExecutable().toString()});
            Runtime.getRuntime().addShutdownHook(new Thread(new RunProcessKiller(runProcess)));
            int exitCode = runProcess.run(true, args, environmentVariables);
            if (exitCode == 0 || exitCode == 130) {
                return;
            }
            throw new MojoExecutionException("Application finished with exit code: " + exitCode);
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Could not exec java", ex);
        }
    }

    @Override
    protected void runWithMavenJvm(String startClassName, String ... arguments) throws MojoExecutionException {
        AbstractRunMojo.IsolatedThreadGroup threadGroup = new AbstractRunMojo.IsolatedThreadGroup(this, startClassName);
        Thread launchThread = new Thread(threadGroup, new AbstractRunMojo.LaunchRunner(this, startClassName, arguments), "main");
        launchThread.setContextClassLoader(new URLClassLoader(this.getClassPathUrls()));
        launchThread.start();
        this.join(threadGroup);
        threadGroup.rethrowUncaughtException();
    }

    private void join(ThreadGroup threadGroup) {
        boolean hasNonDaemonThreads;
        do {
            hasNonDaemonThreads = false;
            Thread[] threads = new Thread[threadGroup.activeCount()];
            threadGroup.enumerate(threads);
            for (Thread thread : threads) {
                if (thread == null || thread.isDaemon()) continue;
                try {
                    hasNonDaemonThreads = true;
                    thread.join();
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
            }
        } while (hasNonDaemonThreads);
    }

    private boolean hasDevtools() {
        if (this.hasDevtools == null) {
            this.hasDevtools = this.checkForDevtools();
        }
        return this.hasDevtools;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkForDevtools() {
        try {
            URL[] urls = this.getClassPathUrls();
            try (URLClassLoader classLoader = new URLClassLoader(urls);){
                boolean bl = classLoader.findResource(RESTARTER_CLASS_LOCATION) != null;
                return bl;
            }
        }
        catch (Exception ex) {
            return false;
        }
    }

    private static final class RunProcessKiller
    implements Runnable {
        private final RunProcess runProcess;

        private RunProcessKiller(RunProcess runProcess) {
            this.runProcess = runProcess;
        }

        @Override
        public void run() {
            this.runProcess.kill();
        }
    }
}

