/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.maven;

import java.io.IOException;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.maven.plugin.MojoExecutionException;

class SpringApplicationAdminClient {
    static final String DEFAULT_OBJECT_NAME = "org.springframework.boot:type=Admin,name=SpringApplication";
    private final MBeanServerConnection connection;
    private final ObjectName objectName;

    SpringApplicationAdminClient(MBeanServerConnection connection, String jmxName) {
        this.connection = connection;
        this.objectName = this.toObjectName(jmxName);
    }

    public boolean isReady() throws MojoExecutionException {
        try {
            return (Boolean)this.connection.getAttribute(this.objectName, "Ready");
        }
        catch (InstanceNotFoundException ex) {
            return false;
        }
        catch (AttributeNotFoundException ex) {
            throw new IllegalStateException("Unexpected: attribute 'Ready' not available", ex);
        }
        catch (ReflectionException ex) {
            throw new MojoExecutionException("Failed to retrieve Ready attribute", ex.getCause());
        }
        catch (IOException | MBeanException ex) {
            throw new MojoExecutionException(ex.getMessage(), ex);
        }
    }

    public void stop() throws MojoExecutionException, IOException, InstanceNotFoundException {
        try {
            this.connection.invoke(this.objectName, "shutdown", null, null);
        }
        catch (ReflectionException ex) {
            throw new MojoExecutionException("Shutdown failed", ex.getCause());
        }
        catch (MBeanException ex) {
            throw new MojoExecutionException("Could not invoke shutdown operation", (Exception)ex);
        }
    }

    private ObjectName toObjectName(String name) {
        try {
            return new ObjectName(name);
        }
        catch (MalformedObjectNameException ex) {
            throw new IllegalArgumentException("Invalid jmx name '" + name + "'");
        }
    }

    public static JMXConnector connect(int port) throws IOException {
        String url = "service:jmx:rmi:///jndi/rmi://127.0.0.1:" + port + "/jmxrmi";
        JMXServiceURL serviceUrl = new JMXServiceURL(url);
        return JMXConnectorFactory.connect(serviceUrl, null);
    }
}

