/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.maven;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.shared.artifact.filter.collection.AbstractArtifactsFilter;
import org.apache.maven.shared.artifact.filter.collection.ArtifactFilterException;
import org.springframework.boot.maven.Exclude;

public class ExcludeFilter
extends AbstractArtifactsFilter {
    private final List<Exclude> excludes;

    public ExcludeFilter(List<Exclude> excludes) {
        this.excludes = excludes;
    }

    public Set filter(Set artifacts) throws ArtifactFilterException {
        HashSet<Artifact> result = new HashSet<Artifact>();
        for (Object a : artifacts) {
            Artifact artifact = (Artifact)a;
            if (this.matchExclude(artifact)) continue;
            result.add(artifact);
        }
        return result;
    }

    private boolean matchExclude(Artifact artifact) {
        for (Exclude exclude : this.excludes) {
            if (!this.match(artifact, exclude)) continue;
            return true;
        }
        return false;
    }

    private boolean match(Artifact artifact, Exclude exclude) {
        if (!exclude.getGroupId().equals(artifact.getGroupId())) {
            return false;
        }
        if (!exclude.getArtifactId().equals(artifact.getArtifactId())) {
            return false;
        }
        return exclude.getClassifier() == null || artifact.getClassifier() != null && exclude.getClassifier().equals(artifact.getClassifier());
    }
}

