/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.kafka.autoconfigure;

import java.io.IOException;
import java.security.KeyStore;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.apache.kafka.common.security.auth.SslEngineFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.util.Assert;

public class SslBundleSslEngineFactory
implements SslEngineFactory {
    private static final String SSL_BUNDLE_CONFIG_NAME = SslBundle.class.getName();
    private @Nullable Map<String, ?> configs;
    private volatile @Nullable SslBundle sslBundle;

    public void configure(Map<String, ?> configs) {
        this.configs = configs;
        this.sslBundle = (SslBundle)configs.get(SSL_BUNDLE_CONFIG_NAME);
    }

    public void close() throws IOException {
    }

    public SSLEngine createClientSslEngine(String peerHost, int peerPort, String endpointIdentification) {
        Assert.state((this.sslBundle != null ? 1 : 0) != 0, (String)"'sslBundle' must not be null");
        SSLEngine sslEngine = this.sslBundle.createSslContext().createSSLEngine(peerHost, peerPort);
        sslEngine.setUseClientMode(true);
        SSLParameters sslParams = sslEngine.getSSLParameters();
        sslParams.setEndpointIdentificationAlgorithm(endpointIdentification);
        sslEngine.setSSLParameters(sslParams);
        return sslEngine;
    }

    public SSLEngine createServerSslEngine(String peerHost, int peerPort) {
        Assert.state((this.sslBundle != null ? 1 : 0) != 0, (String)"'sslBundle' must not be null");
        SSLEngine sslEngine = this.sslBundle.createSslContext().createSSLEngine(peerHost, peerPort);
        sslEngine.setUseClientMode(false);
        return sslEngine;
    }

    public boolean shouldBeRebuilt(Map<String, Object> nextConfigs) {
        return !nextConfigs.equals(this.configs);
    }

    public Set<String> reconfigurableConfigs() {
        return Set.of(SSL_BUNDLE_CONFIG_NAME);
    }

    public @Nullable KeyStore keystore() {
        Assert.state((this.sslBundle != null ? 1 : 0) != 0, (String)"'sslBundle' must not be null");
        return this.sslBundle.getStores().getKeyStore();
    }

    public @Nullable KeyStore truststore() {
        Assert.state((this.sslBundle != null ? 1 : 0) != 0, (String)"'sslBundle' must not be null");
        return this.sslBundle.getStores().getTrustStore();
    }
}

