/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jetty.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.function.Consumer;
import org.eclipse.jetty.util.resource.CombinedResource;
import org.eclipse.jetty.util.resource.Resource;

final class LoaderHidingResource
extends Resource {
    private static final String LOADER_RESOURCE_PATH_PREFIX = "/org/springframework/boot/";
    private final Path loaderBasePath;
    private final Resource base;
    private final Resource delegate;

    LoaderHidingResource(Resource base, Resource delegate) {
        this.base = base;
        this.delegate = delegate;
        this.loaderBasePath = base.getPath().getFileSystem().getPath("/", "org", "springframework", "boot");
    }

    public void forEach(Consumer<? super Resource> action) {
        this.delegate.forEach(action);
    }

    public Path getPath() {
        return this.delegate.getPath();
    }

    public boolean isContainedIn(Resource r) {
        return this.delegate.isContainedIn(r);
    }

    public Iterator<Resource> iterator() {
        if (this.delegate instanceof CombinedResource) {
            return this.list().iterator();
        }
        return List.of(this).iterator();
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public boolean exists() {
        return this.delegate.exists();
    }

    public Spliterator<Resource> spliterator() {
        return this.delegate.spliterator();
    }

    public boolean isDirectory() {
        return this.delegate.isDirectory();
    }

    public boolean isReadable() {
        return this.delegate.isReadable();
    }

    public Instant lastModified() {
        return this.delegate.lastModified();
    }

    public long length() {
        return this.delegate.length();
    }

    public URI getURI() {
        return this.delegate.getURI();
    }

    public String getName() {
        return this.delegate.getName();
    }

    public String getFileName() {
        return this.delegate.getFileName();
    }

    public InputStream newInputStream() throws IOException {
        return this.delegate.newInputStream();
    }

    public ReadableByteChannel newReadableByteChannel() throws IOException {
        return this.delegate.newReadableByteChannel();
    }

    public List<Resource> list() {
        return this.asLoaderHidingResources(this.delegate.list());
    }

    private boolean nonLoaderResource(Resource resource) {
        return !resource.getPath().startsWith(this.loaderBasePath);
    }

    private List<Resource> asLoaderHidingResources(Collection<Resource> resources) {
        return resources.stream().filter(this::nonLoaderResource).map(this::asLoaderHidingResource).toList();
    }

    private Resource asLoaderHidingResource(Resource resource) {
        return resource instanceof LoaderHidingResource ? resource : new LoaderHidingResource(this.base, resource);
    }

    public Resource resolve(String subUriPath) {
        if (subUriPath.startsWith(LOADER_RESOURCE_PATH_PREFIX)) {
            return null;
        }
        Resource resolved = this.delegate.resolve(subUriPath);
        return resolved != null ? new LoaderHidingResource(this.base, resolved) : null;
    }

    public boolean isAlias() {
        return this.delegate.isAlias();
    }

    public URI getRealURI() {
        return this.delegate.getRealURI();
    }

    public void copyTo(Path destination) throws IOException {
        this.delegate.copyTo(destination);
    }

    public Collection<Resource> getAllResources() {
        return this.asLoaderHidingResources(this.delegate.getAllResources());
    }

    public String toString() {
        return this.delegate.toString();
    }
}

