/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jetty.servlet;

import java.util.List;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.springframework.boot.jetty.JettyWebServer;
import org.springframework.boot.jetty.servlet.JettyEmbeddedWebAppContext;

public class JettyServletWebServer
extends JettyWebServer {
    public JettyServletWebServer(Server server) {
        super(server);
    }

    public JettyServletWebServer(Server server, boolean autoStart) {
        super(server, autoStart);
    }

    @Override
    protected void handleDeferredInitialize(Server server) throws Exception {
        this.handleDeferredInitialize(server.getHandlers());
    }

    protected void handleDeferredInitialize(List<Handler> handlers) throws Exception {
        for (Handler handler : handlers) {
            this.handleDeferredInitialize(handler);
        }
    }

    private void handleDeferredInitialize(Handler handler) throws Exception {
        if (handler instanceof JettyEmbeddedWebAppContext) {
            JettyEmbeddedWebAppContext jettyEmbeddedWebAppContext = (JettyEmbeddedWebAppContext)handler;
            jettyEmbeddedWebAppContext.deferredInitialize();
        } else if (handler instanceof Handler.Wrapper) {
            Handler.Wrapper handlerWrapper = (Handler.Wrapper)handler;
            this.handleDeferredInitialize(handlerWrapper.getHandler());
        } else if (handler instanceof Handler.Collection) {
            Handler.Collection handlerCollection = (Handler.Collection)handler;
            this.handleDeferredInitialize(handlerCollection.getHandlers());
        }
    }
}

