/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jetty.autoconfigure.actuate.web.server;

import java.io.File;
import org.eclipse.jetty.server.CustomRequestLog;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.RequestLogWriter;
import org.eclipse.jetty.server.Server;
import org.springframework.boot.actuate.autoconfigure.web.server.AccessLogCustomizer;
import org.springframework.boot.jetty.ConfigurableJettyWebServerFactory;
import org.springframework.boot.jetty.autoconfigure.actuate.web.server.JettyManagementServerProperties;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.util.StringUtils;

class JettyAccessLogCustomizer
extends AccessLogCustomizer<ConfigurableJettyWebServerFactory>
implements WebServerFactoryCustomizer<ConfigurableJettyWebServerFactory> {
    JettyAccessLogCustomizer(JettyManagementServerProperties properties) {
        super(properties.getAccesslog().getPrefix());
    }

    public void customize(ConfigurableJettyWebServerFactory factory) {
        factory.addServerCustomizers(this::customizeServer);
    }

    private void customizeServer(Server server) {
        RequestLog requestLog = server.getRequestLog();
        if (requestLog instanceof CustomRequestLog) {
            CustomRequestLog customRequestLog = (CustomRequestLog)requestLog;
            this.customizeRequestLog(customRequestLog);
        }
    }

    private void customizeRequestLog(CustomRequestLog requestLog) {
        RequestLog.Writer writer = requestLog.getWriter();
        if (writer instanceof RequestLogWriter) {
            RequestLogWriter requestLogWriter = (RequestLogWriter)writer;
            this.customizeRequestLogWriter(requestLogWriter);
        }
    }

    private void customizeRequestLogWriter(RequestLogWriter writer) {
        String filename = writer.getFileName();
        if (StringUtils.hasLength((String)filename)) {
            File file = new File(filename);
            file = new File(file.getParentFile(), this.customizePrefix(file.getName()));
            writer.setFilename(file.getPath());
        }
    }
}

