/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jetty;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import org.eclipse.jetty.ee10.webapp.Configuration;
import org.eclipse.jetty.http2.server.HTTP2CServerConnectionFactory;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.server.AbstractConnector;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.springframework.boot.jetty.ConfigurableJettyWebServerFactory;
import org.springframework.boot.jetty.JettyHandlerWrappers;
import org.springframework.boot.jetty.JettyServerCustomizer;
import org.springframework.boot.jetty.SslServerCustomizer;
import org.springframework.boot.web.server.AbstractConfigurableWebServerFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class JettyWebServerFactory
extends AbstractConfigurableWebServerFactory
implements ConfigurableJettyWebServerFactory {
    private int acceptors = -1;
    private ThreadPool threadPool;
    private int selectors = -1;
    private List<Configuration> configurations = new ArrayList<Configuration>();
    private boolean useForwardHeaders;
    private Set<JettyServerCustomizer> jettyServerCustomizers = new LinkedHashSet<JettyServerCustomizer>();
    private int maxConnections = -1;

    public JettyWebServerFactory() {
    }

    public JettyWebServerFactory(int port) {
        super(port);
    }

    public int getAcceptors() {
        return this.acceptors;
    }

    @Override
    public void setAcceptors(int acceptors) {
        this.acceptors = acceptors;
    }

    public int getSelectors() {
        return this.selectors;
    }

    @Override
    public void setSelectors(int selectors) {
        this.selectors = selectors;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    @Override
    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public Collection<JettyServerCustomizer> getServerCustomizers() {
        return this.jettyServerCustomizers;
    }

    public void setServerCustomizers(Collection<? extends JettyServerCustomizer> customizers) {
        Assert.notNull(customizers, (String)"'customizers' must not be null");
        this.jettyServerCustomizers = new LinkedHashSet<JettyServerCustomizer>(customizers);
    }

    @Override
    public void addServerCustomizers(JettyServerCustomizer ... customizers) {
        Assert.notNull((Object)customizers, (String)"'customizers' must not be null");
        this.jettyServerCustomizers.addAll(Arrays.asList(customizers));
    }

    public Collection<Configuration> getConfigurations() {
        return this.configurations;
    }

    public void setConfigurations(Collection<? extends Configuration> configurations) {
        Assert.notNull(configurations, (String)"'configurations' must not be null");
        this.configurations = new ArrayList<Configuration>(configurations);
    }

    public void addConfigurations(Configuration ... configurations) {
        Assert.notNull((Object)configurations, (String)"'configurations' must not be null");
        this.configurations.addAll(Arrays.asList(configurations));
    }

    public ThreadPool getThreadPool() {
        return this.threadPool;
    }

    @Override
    public void setThreadPool(ThreadPool threadPool) {
        this.threadPool = threadPool;
    }

    public boolean isUseForwardHeaders() {
        return this.useForwardHeaders;
    }

    @Override
    public void setUseForwardHeaders(boolean useForwardHeaders) {
        this.useForwardHeaders = useForwardHeaders;
    }

    protected AbstractConnector createConnector(InetSocketAddress address, Server server) {
        return this.createConnector(address, server, null, null, null);
    }

    protected AbstractConnector createConnector(InetSocketAddress address, Server server, Executor executor, Scheduler scheduler, ByteBufferPool pool) {
        HttpConfiguration httpConfiguration = new HttpConfiguration();
        httpConfiguration.setSendServerVersion(false);
        ArrayList<Object> connectionFactories = new ArrayList<Object>();
        connectionFactories.add(new HttpConnectionFactory(httpConfiguration));
        if (this.getHttp2() != null && this.getHttp2().isEnabled()) {
            connectionFactories.add(new HTTP2CServerConnectionFactory(httpConfiguration));
        }
        ServerConnector connector = new ServerConnector(server, executor, scheduler, pool, this.getAcceptors(), this.getSelectors(), connectionFactories.toArray(new ConnectionFactory[0]));
        connector.setHost(address.getHostString());
        connector.setPort(address.getPort());
        return connector;
    }

    protected void customizeSsl(Server server, InetSocketAddress address) {
        Assert.state((boolean)this.getSsl().getServerNameBundles().isEmpty(), (String)"Server name SSL bundles are not supported with Jetty");
        new SslServerCustomizer(this.getHttp2(), address, this.getSsl().getClientAuth(), this.getSslBundle()).customize(server);
    }

    protected Handler addHandlerWrappers(Handler handler) {
        if (this.getCompression() != null && this.getCompression().getEnabled()) {
            handler = this.applyWrapper(handler, JettyHandlerWrappers.createGzipHandlerWrapper(this.getCompression()));
        }
        if (StringUtils.hasText((String)this.getServerHeader())) {
            handler = this.applyWrapper(handler, JettyHandlerWrappers.createServerHeaderHandlerWrapper(this.getServerHeader()));
        }
        return handler;
    }

    protected Handler applyWrapper(Handler handler, Handler.Wrapper wrapper) {
        wrapper.setHandler(handler);
        return wrapper;
    }
}

