/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jersey.autoconfigure.actuate.web;

import org.glassfish.jersey.server.ResourceConfig;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.web.ManagementContextConfiguration;
import org.springframework.boot.actuate.autoconfigure.web.ManagementContextType;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.jersey.autoconfigure.DefaultJerseyApplicationPath;
import org.springframework.boot.jersey.autoconfigure.JerseyApplicationPath;
import org.springframework.boot.jersey.autoconfigure.JerseyProperties;
import org.springframework.boot.jersey.autoconfigure.ResourceConfigCustomizer;
import org.springframework.boot.jersey.autoconfigure.actuate.web.JerseyManagementContextConfiguration;
import org.springframework.boot.jersey.autoconfigure.actuate.web.ManagementContextResourceConfigCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@ManagementContextConfiguration(value=ManagementContextType.SAME, proxyBeanMethods=false)
@EnableConfigurationProperties(value={JerseyProperties.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnClass(value={JerseyApplicationPath.class, ResourceConfig.class})
@ConditionalOnMissingClass(value={"org.springframework.web.servlet.DispatcherServlet"})
public class JerseySameManagementContextConfiguration {
    @Bean
    ResourceConfigCustomizer managementResourceConfigCustomizerAdapter(ObjectProvider<ManagementContextResourceConfigCustomizer> customizers) {
        return config -> customizers.orderedStream().forEach(customizer -> customizer.customize(config));
    }

    @Configuration(proxyBeanMethods=false)
    @Import(value={JerseyManagementContextConfiguration.class})
    @ConditionalOnMissingBean(value={ResourceConfig.class})
    static class JerseyInfrastructureConfiguration {
        JerseyInfrastructureConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        JerseyApplicationPath jerseyApplicationPath(JerseyProperties properties, ResourceConfig config) {
            return new DefaultJerseyApplicationPath(properties.getApplicationPath(), config);
        }

        @Bean
        ResourceConfig resourceConfig(ObjectProvider<ResourceConfigCustomizer> resourceConfigCustomizers) {
            ResourceConfig resourceConfig = new ResourceConfig();
            resourceConfigCustomizers.orderedStream().forEach(customizer -> customizer.customize(resourceConfig));
            return resourceConfig;
        }
    }
}

