/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jersey.autoconfigure.actuate.web;

import org.glassfish.jersey.server.ResourceConfig;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.web.ManagementContextConfiguration;
import org.springframework.boot.actuate.autoconfigure.web.ManagementContextType;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.jersey.autoconfigure.JerseyApplicationPath;
import org.springframework.boot.jersey.autoconfigure.actuate.web.JerseyManagementContextConfiguration;
import org.springframework.boot.jersey.autoconfigure.actuate.web.ManagementContextResourceConfigCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;

@ManagementContextConfiguration(value=ManagementContextType.CHILD, proxyBeanMethods=false)
@Import(value={JerseyManagementContextConfiguration.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnClass(value={JerseyApplicationPath.class, ResourceConfig.class})
@ConditionalOnMissingClass(value={"org.springframework.web.servlet.DispatcherServlet"})
public class JerseyChildManagementContextConfiguration {
    @Bean
    public JerseyApplicationPath jerseyApplicationPath() {
        return () -> "/";
    }

    @Bean
    ResourceConfig resourceConfig(ObjectProvider<ManagementContextResourceConfigCustomizer> customizers) {
        ResourceConfig resourceConfig = new ResourceConfig();
        customizers.orderedStream().forEach(customizer -> customizer.customize(resourceConfig));
        return resourceConfig;
    }
}

