/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jarmode.tools;

import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.jarmode.tools.Command;
import org.springframework.boot.jarmode.tools.Context;

class HelpCommand
extends Command {
    private final Context context;
    private final List<Command> commands;
    private final String jarMode;

    HelpCommand(Context context, List<Command> commands) {
        this(context, commands, System.getProperty("jarmode"));
    }

    HelpCommand(Context context, List<Command> commands, @Nullable String jarMode) {
        super("help", "Help about any command", Command.Options.none(), Command.Parameters.of("[<command>]"));
        this.context = context;
        this.commands = commands;
        this.jarMode = jarMode != null ? jarMode : "tools";
    }

    @Override
    void run(PrintStream out, Map<Command.Option, String> options, List<String> parameters) {
        this.run(out, parameters);
    }

    void run(PrintStream out, List<String> parameters) {
        String commandName;
        String string = commandName = parameters.isEmpty() ? null : parameters.get(0);
        if (commandName == null) {
            this.printUsageAndCommands(out);
            return;
        }
        if (this.getName().equals(commandName)) {
            this.printCommandHelp(out, this, true);
            return;
        }
        Command command = Command.find(this.commands, commandName);
        if (command == null) {
            this.printError(out, "Unknown command \"%s\"".formatted(commandName));
            this.printUsageAndCommands(out);
            return;
        }
        this.printCommandHelp(out, command, true);
    }

    void printCommandHelp(PrintStream out, Command command, boolean printDeprecationWarning) {
        if (command.isDeprecated() && printDeprecationWarning) {
            this.printWarning(out, "This command is deprecated. " + command.getDeprecationMessage());
        }
        out.println(command.getDescription());
        out.println();
        out.println("Usage:");
        out.println("  " + this.getJavaCommand() + " " + this.getUsage(command));
        if (!command.getOptions().isEmpty()) {
            out.println();
            out.println("Options:");
            int maxNameLength = this.getMaxLength(0, command.getOptions().stream().map(Command.Option::getNameAndValueDescription));
            command.getOptions().stream().forEach(option -> this.printOptionSummary(out, (Command.Option)option, maxNameLength));
        }
    }

    private void printOptionSummary(PrintStream out, Command.Option option, int padding) {
        out.printf("  --%-" + padding + "s  %s%n", option.getNameAndValueDescription(), option.getDescription());
    }

    private String getUsage(Command command) {
        StringBuilder usage = new StringBuilder();
        usage.append(command.getName());
        if (!command.getOptions().isEmpty()) {
            usage.append(" [options]");
        }
        command.getParameters().getDescriptions().forEach(param -> usage.append(" ").append((String)param));
        return usage.toString();
    }

    private void printUsageAndCommands(PrintStream out) {
        out.println("Usage:");
        out.println("  " + this.getJavaCommand());
        out.println();
        out.println("Available commands:");
        int maxNameLength = this.getMaxLength(this.getName().length(), this.commands.stream().map(Command::getName));
        this.commands.stream().filter(command -> !command.isDeprecated()).forEach(command -> this.printCommandSummary(out, (Command)command, maxNameLength));
        this.printCommandSummary(out, this, maxNameLength);
        List<Command> deprecatedCommands = this.commands.stream().filter(Command::isDeprecated).toList();
        if (!deprecatedCommands.isEmpty()) {
            out.println("Deprecated commands:");
            for (Command command2 : deprecatedCommands) {
                this.printCommandSummary(out, command2, maxNameLength);
            }
        }
    }

    private int getMaxLength(int minimum, Stream<String> strings) {
        return Math.max(minimum, strings.mapToInt(String::length).max().orElse(0));
    }

    private void printCommandSummary(PrintStream out, Command command, int padding) {
        out.printf("  %-" + padding + "s  %s%n", command.getName(), command.getDescription());
    }

    private String getJavaCommand() {
        return "java -Djarmode=" + this.jarMode + " -jar " + this.context.getArchiveFile().getName();
    }

    private void printError(PrintStream out, String errorMessage) {
        out.println("Error: " + errorMessage);
        out.println();
    }

    private void printWarning(PrintStream out, String errorMessage) {
        out.println("Warning: " + errorMessage);
        out.println();
    }
}

