/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jarmode.layertools;

import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.springframework.boot.jarmode.layertools.Command;
import org.springframework.boot.jarmode.layertools.Context;

class HelpCommand
extends Command {
    private final Context context;
    private final List<Command> commands;

    HelpCommand(Context context, List<Command> commands) {
        super("help", "Help about any command", Command.Options.none(), Command.Parameters.of("[<command]"));
        this.context = context;
        this.commands = commands;
    }

    @Override
    protected void run(Map<Command.Option, String> options, List<String> parameters) {
        this.run(System.out, parameters);
    }

    void run(PrintStream out, List<String> parameters) {
        Command command;
        Command command2 = command = !parameters.isEmpty() ? Command.find(this.commands, parameters.get(0)) : null;
        if (command != null) {
            this.printCommandHelp(out, command);
            return;
        }
        this.printUsageAndCommands(out);
    }

    private void printCommandHelp(PrintStream out, Command command) {
        out.println(command.getDescription());
        out.println();
        out.println("Usage:");
        out.println("  " + this.getJavaCommand() + " " + this.getUsage(command));
        if (!command.getOptions().isEmpty()) {
            out.println();
            out.println("Options:");
            int maxNameLength = this.getMaxLength(0, command.getOptions().stream().map(Command.Option::getNameAndValueDescription));
            command.getOptions().stream().forEach(option -> this.printOptionSummary(out, (Command.Option)option, maxNameLength));
        }
    }

    private void printOptionSummary(PrintStream out, Command.Option option, int padding) {
        out.printf("  --%-" + padding + "s  %s%n", option.getNameAndValueDescription(), option.getDescription());
    }

    private String getUsage(Command command) {
        StringBuilder usage = new StringBuilder();
        usage.append(command.getName());
        if (!command.getOptions().isEmpty()) {
            usage.append(" [options]");
        }
        command.getParameters().getDescriptions().forEach(param -> usage.append(" ").append((String)param));
        return usage.toString();
    }

    private void printUsageAndCommands(PrintStream out) {
        out.println("Usage:");
        out.println("  " + this.getJavaCommand());
        out.println();
        out.println("Available commands:");
        int maxNameLength = this.getMaxLength(this.getName().length(), this.commands.stream().map(Command::getName));
        this.commands.forEach(command -> this.printCommandSummary(out, (Command)command, maxNameLength));
        this.printCommandSummary(out, this, maxNameLength);
    }

    private int getMaxLength(int minimum, Stream<String> strings) {
        return Math.max(minimum, strings.mapToInt(String::length).max().orElse(0));
    }

    private void printCommandSummary(PrintStream out, Command command, int padding) {
        out.printf("  %-" + padding + "s  %s%n", command.getName(), command.getDescription());
    }

    private String getJavaCommand() {
        return "java -Djarmode=layertools -jar " + this.context.getArchiveFile().getName();
    }
}

