/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jarmode.layertools;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

abstract class Command {
    private final String name;
    private final String description;
    private final Options options;
    private final Parameters parameters;

    Command(String name, String description, Options options, Parameters parameters) {
        this.name = name;
        this.description = description;
        this.options = options;
        this.parameters = parameters;
    }

    String getName() {
        return this.name;
    }

    String getDescription() {
        return this.description;
    }

    Options getOptions() {
        return this.options;
    }

    Parameters getParameters() {
        return this.parameters;
    }

    final void run(Deque<String> args) {
        ArrayList<String> parameters = new ArrayList<String>();
        HashMap<Option, String> options = new HashMap<Option, String>();
        while (!args.isEmpty()) {
            String arg = args.removeFirst();
            Option option = this.options.find(arg);
            if (option != null) {
                options.put(option, option.claimArg(args));
                continue;
            }
            parameters.add(arg);
        }
        this.run(options, parameters);
    }

    protected abstract void run(Map<Option, String> var1, List<String> var2);

    static Command find(Collection<? extends Command> commands, String name) {
        for (Command command : commands) {
            if (!command.getName().equals(name)) continue;
            return command;
        }
        return null;
    }

    protected static final class Option {
        private final String name;
        private final String valueDescription;
        private final String description;

        private Option(String name, String valueDescription, String description) {
            this.name = name;
            this.description = description;
            this.valueDescription = valueDescription;
        }

        String getName() {
            return this.name;
        }

        String getValueDescription() {
            return this.valueDescription;
        }

        String getNameAndValueDescription() {
            return this.name + (this.valueDescription != null ? " " + this.valueDescription : "");
        }

        String getDescription() {
            return this.description;
        }

        private String claimArg(Deque<String> args) {
            return this.valueDescription != null ? args.removeFirst() : null;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            return this.name.equals(((Option)obj).name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            return this.name;
        }

        protected static Option flag(String name, String description) {
            return new Option(name, null, description);
        }

        protected static Option of(String name, String valueDescription, String description) {
            return new Option(name, valueDescription, description);
        }
    }

    protected static final class Options {
        private final Option[] values;

        private Options(Option[] values) {
            this.values = values;
        }

        private Option find(String arg) {
            if (arg.startsWith("--")) {
                String name = arg.substring(2);
                for (Option candidate : this.values) {
                    if (!candidate.getName().equals(name)) continue;
                    return candidate;
                }
            }
            return null;
        }

        boolean isEmpty() {
            return this.values.length == 0;
        }

        Stream<Option> stream() {
            return Arrays.stream(this.values);
        }

        protected static Options none() {
            return Options.of(new Option[0]);
        }

        protected static Options of(Option ... values) {
            return new Options(values);
        }
    }

    protected static final class Parameters {
        private final List<String> descriptions;

        private Parameters(String[] descriptions) {
            this.descriptions = Collections.unmodifiableList(Arrays.asList(descriptions));
        }

        List<String> getDescriptions() {
            return this.descriptions;
        }

        public String toString() {
            return this.descriptions.toString();
        }

        protected static Parameters none() {
            return Parameters.of(new String[0]);
        }

        protected static Parameters of(String ... descriptions) {
            return new Parameters(descriptions);
        }
    }
}

