/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.http.client.autoconfigure;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.http.client.autoconfigure.ApiversionProperties;
import org.springframework.http.HttpHeaders;
import org.springframework.web.client.ApiVersionFormatter;
import org.springframework.web.client.ApiVersionInserter;

public final class PropertiesApiVersionInserter
implements ApiVersionInserter {
    private final List<ApiVersionInserter> inserters;

    private PropertiesApiVersionInserter(List<ApiVersionInserter> inserters) {
        this.inserters = inserters;
    }

    public URI insertVersion(Object version, URI uri) {
        for (ApiVersionInserter delegate : this.inserters) {
            uri = delegate.insertVersion(version, uri);
        }
        return uri;
    }

    public void insertVersion(Object version, HttpHeaders headers) {
        for (ApiVersionInserter delegate : this.inserters) {
            delegate.insertVersion(version, headers);
        }
    }

    public static @Nullable ApiVersionInserter get(@Nullable ApiVersionInserter apiVersionInserter, @Nullable ApiVersionFormatter apiVersionFormatter, ApiversionProperties ... properties) {
        return PropertiesApiVersionInserter.get(apiVersionInserter, apiVersionFormatter, Arrays.stream(properties));
    }

    public static @Nullable ApiVersionInserter get(@Nullable ApiVersionInserter apiVersionInserter, @Nullable ApiVersionFormatter apiVersionFormatter, Stream<ApiversionProperties> propertiesStream) {
        ArrayList<ApiVersionInserter> inserters = new ArrayList<ApiVersionInserter>();
        if (apiVersionInserter != null) {
            inserters.add(apiVersionInserter);
        }
        PropertyMapper map = PropertyMapper.get();
        propertiesStream.forEach(properties -> {
            if (properties != null && properties.getInsert() != null) {
                ApiversionProperties.Insert insert = properties.getInsert();
                Counter counter = new Counter();
                ApiVersionInserter.Builder builder = ApiVersionInserter.builder();
                map.from((Object)apiVersionFormatter).to(arg_0 -> ((ApiVersionInserter.Builder)builder).withVersionFormatter(arg_0));
                map.from(insert::getHeader).whenHasText().as(counter::counted).to(arg_0 -> ((ApiVersionInserter.Builder)builder).useHeader(arg_0));
                map.from(insert::getQueryParameter).whenHasText().as(counter::counted).to(arg_0 -> ((ApiVersionInserter.Builder)builder).useQueryParam(arg_0));
                map.from(insert::getPathSegment).as(counter::counted).to(arg_0 -> ((ApiVersionInserter.Builder)builder).usePathSegment(arg_0));
                map.from(insert::getMediaTypeParameter).to(arg_0 -> ((ApiVersionInserter.Builder)builder).useMediaTypeParam(arg_0));
                if (!counter.isEmpty()) {
                    inserters.add(builder.build());
                }
            }
        });
        return !inserters.isEmpty() ? new PropertiesApiVersionInserter(inserters) : null;
    }

    private static final class Counter {
        private boolean empty = true;

        private Counter() {
        }

        <T> T counted(T value) {
            this.empty = false;
            return value;
        }

        boolean isEmpty() {
            return this.empty;
        }
    }
}

