/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.http.client.autoconfigure;

import java.time.Duration;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.context.properties.ConfigurationPropertiesSource;
import org.springframework.boot.http.client.ClientHttpRequestFactoryBuilder;
import org.springframework.boot.http.client.HttpRedirects;

@ConfigurationPropertiesSource
public abstract class AbstractHttpRequestFactoryProperties {
    private @Nullable HttpRedirects redirects;
    private @Nullable Duration connectTimeout;
    private @Nullable Duration readTimeout;
    private final Ssl ssl = new Ssl();
    private @Nullable Factory factory;

    public @Nullable HttpRedirects getRedirects() {
        return this.redirects;
    }

    public void setRedirects(@Nullable HttpRedirects redirects) {
        this.redirects = redirects;
    }

    public @Nullable Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(@Nullable Duration connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public @Nullable Duration getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(@Nullable Duration readTimeout) {
        this.readTimeout = readTimeout;
    }

    public Ssl getSsl() {
        return this.ssl;
    }

    public @Nullable Factory getFactory() {
        return this.factory;
    }

    public void setFactory(@Nullable Factory factory) {
        this.factory = factory;
    }

    @ConfigurationPropertiesSource
    public static class Ssl {
        private @Nullable String bundle;

        public @Nullable String getBundle() {
            return this.bundle;
        }

        public void setBundle(@Nullable String bundle) {
            this.bundle = bundle;
        }
    }

    public static enum Factory {
        HTTP_COMPONENTS(ClientHttpRequestFactoryBuilder::httpComponents),
        JETTY(ClientHttpRequestFactoryBuilder::jetty),
        REACTOR(ClientHttpRequestFactoryBuilder::reactor),
        JDK(ClientHttpRequestFactoryBuilder::jdk),
        SIMPLE(ClientHttpRequestFactoryBuilder::simple);

        private final Supplier<ClientHttpRequestFactoryBuilder<?>> builderSupplier;

        private Factory(Supplier<ClientHttpRequestFactoryBuilder<?>> builderSupplier) {
            this.builderSupplier = builderSupplier;
        }

        ClientHttpRequestFactoryBuilder<?> builder() {
            return this.builderSupplier.get();
        }
    }
}

