/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.http.client;

import java.time.Duration;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.http.client.HttpRedirects;
import org.springframework.boot.ssl.SslBundle;

public record ClientHttpRequestFactorySettings(HttpRedirects redirects, @Nullable Duration connectTimeout, @Nullable Duration readTimeout, @Nullable SslBundle sslBundle) {
    private static final ClientHttpRequestFactorySettings defaults = new ClientHttpRequestFactorySettings(null, null, null, null);

    public ClientHttpRequestFactorySettings(@Nullable HttpRedirects redirects, @Nullable Duration connectTimeout, @Nullable Duration readTimeout, @Nullable SslBundle sslBundle) {
        this.redirects = redirects != null ? redirects : HttpRedirects.FOLLOW_WHEN_POSSIBLE;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.sslBundle = sslBundle;
    }

    public ClientHttpRequestFactorySettings withConnectTimeout(@Nullable Duration connectTimeout) {
        return new ClientHttpRequestFactorySettings(this.redirects, connectTimeout, this.readTimeout, this.sslBundle);
    }

    public ClientHttpRequestFactorySettings withReadTimeout(@Nullable Duration readTimeout) {
        return new ClientHttpRequestFactorySettings(this.redirects, this.connectTimeout, readTimeout, this.sslBundle);
    }

    public ClientHttpRequestFactorySettings withTimeouts(@Nullable Duration connectTimeout, @Nullable Duration readTimeout) {
        return new ClientHttpRequestFactorySettings(this.redirects, connectTimeout, readTimeout, this.sslBundle);
    }

    public ClientHttpRequestFactorySettings withSslBundle(@Nullable SslBundle sslBundle) {
        return new ClientHttpRequestFactorySettings(this.redirects, this.connectTimeout, this.readTimeout, sslBundle);
    }

    public ClientHttpRequestFactorySettings withRedirects(@Nullable HttpRedirects redirects) {
        return new ClientHttpRequestFactorySettings(redirects, this.connectTimeout, this.readTimeout, this.sslBundle);
    }

    public static ClientHttpRequestFactorySettings ofSslBundle(@Nullable SslBundle sslBundle) {
        return ClientHttpRequestFactorySettings.defaults().withSslBundle(sslBundle);
    }

    public static ClientHttpRequestFactorySettings defaults() {
        return defaults;
    }
}

