/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.http.client.autoconfigure.service;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.HierarchicalBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.http.client.autoconfigure.service.ConditionalOnMissingHttpServiceProxyBean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.core.type.AnnotatedTypeMetadata;

class OnMissingHttpServiceProxyBeanCondition
extends SpringBootCondition
implements ConfigurationCondition {
    static final String HTTP_SERVICE_GROUP_NAME_ATTRIBUTE = "httpServiceGroupName";

    OnMissingHttpServiceProxyBeanCondition() {
    }

    public ConfigurationCondition.ConfigurationPhase getConfigurationPhase() {
        return ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN;
    }

    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        ConditionMessage.Builder message = ConditionMessage.forCondition(ConditionalOnMissingHttpServiceProxyBean.class, (Object[])new Object[0]);
        ConfigurableListableBeanFactory beanFactory = context.getBeanFactory();
        while (beanFactory != null) {
            BeanFactory beanFactory2;
            ConfigurableListableBeanFactory configurableListableBeanFactory;
            if (beanFactory instanceof ConfigurableListableBeanFactory && this.hasHttpServiceProxyBeanDefinition(configurableListableBeanFactory = beanFactory)) {
                return ConditionOutcome.noMatch((ConditionMessage)message.foundExactly((Object)"HTTP Service proxy bean"));
            }
            if (beanFactory instanceof HierarchicalBeanFactory) {
                HierarchicalBeanFactory hierarchicalBeanFactory = (HierarchicalBeanFactory)beanFactory;
                beanFactory2 = hierarchicalBeanFactory.getParentBeanFactory();
            } else {
                beanFactory2 = null;
            }
            beanFactory = beanFactory2;
        }
        return ConditionOutcome.match((ConditionMessage)message.didNotFind("").items(new Object[]{"HTTP Service proxy beans"}));
    }

    private boolean hasHttpServiceProxyBeanDefinition(ConfigurableListableBeanFactory beanFactory) {
        for (String beanName : beanFactory.getBeanDefinitionNames()) {
            BeanDefinition beanDefinition = beanFactory.getBeanDefinition(beanName);
            if (!beanDefinition.hasAttribute(HTTP_SERVICE_GROUP_NAME_ATTRIBUTE)) continue;
            return true;
        }
        return false;
    }
}

