/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.http.client.autoconfigure.reactive;

import java.util.List;
import java.util.concurrent.Executor;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.ssl.SslAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.http.client.autoconfigure.reactive.ClientHttpConnectorBuilderCustomizer;
import org.springframework.boot.http.client.autoconfigure.reactive.ClientHttpConnectors;
import org.springframework.boot.http.client.autoconfigure.reactive.ConditionalOnClientHttpConnectorBuilderDetection;
import org.springframework.boot.http.client.autoconfigure.reactive.HttpReactiveClientProperties;
import org.springframework.boot.http.client.reactive.ClientHttpConnectorBuilder;
import org.springframework.boot.http.client.reactive.ClientHttpConnectorSettings;
import org.springframework.boot.http.client.reactive.JdkClientHttpConnectorBuilder;
import org.springframework.boot.http.client.reactive.ReactorClientHttpConnectorBuilder;
import org.springframework.boot.reactor.netty.autoconfigure.ReactorNettyConfigurations;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.boot.thread.Threading;
import org.springframework.boot.util.LambdaSafe;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.core.task.VirtualThreadTaskExecutor;
import org.springframework.http.client.ReactorResourceFactory;
import org.springframework.http.client.reactive.ClientHttpConnector;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.HttpClient;

@AutoConfiguration(after={SslAutoConfiguration.class})
@ConditionalOnClass(value={ClientHttpConnector.class, Mono.class})
@Conditional(value={ConditionalOnClientHttpConnectorBuilderDetection.class})
@EnableConfigurationProperties(value={HttpReactiveClientProperties.class})
public final class ClientHttpConnectorAutoConfiguration
implements BeanClassLoaderAware {
    private final ClientHttpConnectors connectors;
    private final Environment environment;
    private ClassLoader beanClassLoader;

    ClientHttpConnectorAutoConfiguration(Environment environment, ObjectProvider<SslBundles> sslBundles, HttpReactiveClientProperties properties) {
        this.environment = environment;
        this.connectors = new ClientHttpConnectors((ObjectFactory<SslBundles>)sslBundles, properties);
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    @Bean
    @ConditionalOnMissingBean
    ClientHttpConnectorBuilder<?> clientHttpConnectorBuilder(ObjectProvider<ClientHttpConnectorBuilderCustomizer<?>> clientHttpConnectorBuilderCustomizers) {
        JdkClientHttpConnectorBuilder builder = this.connectors.builder(this.beanClassLoader);
        if (builder instanceof JdkClientHttpConnectorBuilder) {
            JdkClientHttpConnectorBuilder jdk = builder;
            if (Threading.VIRTUAL.isActive(this.environment)) {
                builder = jdk.withExecutor((Executor)new VirtualThreadTaskExecutor("httpclient-"));
            }
        }
        return this.customize(builder, clientHttpConnectorBuilderCustomizers.orderedStream().toList());
    }

    private ClientHttpConnectorBuilder<?> customize(ClientHttpConnectorBuilder<?> builder, List<ClientHttpConnectorBuilderCustomizer<?>> customizers) {
        ClientHttpConnectorBuilder[] builderReference = new ClientHttpConnectorBuilder[]{builder};
        LambdaSafe.callbacks(ClientHttpConnectorBuilderCustomizer.class, customizers, (Object)builderReference[0], (Object[])new Object[0]).invoke(customizer -> {
            builderReference[0] = customizer.customize(builderReference[0]);
        });
        return builderReference[0];
    }

    @Bean
    @ConditionalOnMissingBean
    ClientHttpConnectorSettings clientHttpConnectorSettings() {
        return this.connectors.settings();
    }

    @Bean
    @Lazy
    @ConditionalOnMissingBean
    ClientHttpConnector clientHttpConnector(ClientHttpConnectorBuilder<?> clientHttpConnectorBuilder, ClientHttpConnectorSettings clientHttpRequestFactorySettings) {
        return clientHttpConnectorBuilder.build(clientHttpRequestFactorySettings);
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={HttpClient.class, ReactorNettyConfigurations.class})
    @Import(value={ReactorNettyConfigurations.ReactorResourceFactoryConfiguration.class})
    static class ReactorNetty {
        ReactorNetty() {
        }

        @Bean
        @Order(value=0)
        ClientHttpConnectorBuilderCustomizer<ReactorClientHttpConnectorBuilder> reactorResourceFactoryClientHttpConnectorBuilderCustomizer(ReactorResourceFactory reactorResourceFactory) {
            return builder -> builder.withReactorResourceFactory(reactorResourceFactory);
        }
    }
}

