/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.hazelcast.autoconfigure;

import com.hazelcast.core.HazelcastInstance;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.AllNestedConditions;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.hazelcast.autoconfigure.HazelcastAutoConfiguration;
import org.springframework.boot.jpa.autoconfigure.EntityManagerFactoryDependsOnPostProcessor;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.context.annotation.Import;
import org.springframework.orm.jpa.AbstractEntityManagerFactoryBean;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;

@AutoConfiguration(after={HazelcastAutoConfiguration.class}, afterName={"org.springframework.boot.hibernate.autoconfigure.HibernateJpaAutoConfiguration"})
@ConditionalOnClass(value={HazelcastInstance.class, LocalContainerEntityManagerFactoryBean.class})
@Import(value={HazelcastInstanceEntityManagerFactoryDependsOnConfiguration.class})
public final class HazelcastJpaDependencyAutoConfiguration {

    static class OnHazelcastAndJpaCondition
    extends AllNestedConditions {
        OnHazelcastAndJpaCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnBean(value={AbstractEntityManagerFactoryBean.class})
        static class HasJpa {
            HasJpa() {
            }
        }

        @ConditionalOnBean(name={"hazelcastInstance"})
        static class HasHazelcastInstance {
            HasHazelcastInstance() {
            }
        }
    }

    static class HazelcastInstanceEntityManagerFactoryDependsOnPostProcessor
    extends EntityManagerFactoryDependsOnPostProcessor {
        HazelcastInstanceEntityManagerFactoryDependsOnPostProcessor() {
            super(new String[]{"hazelcastInstance"});
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={EntityManagerFactoryDependsOnPostProcessor.class})
    @Conditional(value={OnHazelcastAndJpaCondition.class})
    @Import(value={HazelcastInstanceEntityManagerFactoryDependsOnPostProcessor.class})
    static class HazelcastInstanceEntityManagerFactoryDependsOnConfiguration {
        HazelcastInstanceEntityManagerFactoryDependsOnConfiguration() {
        }
    }
}

