/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.h2console.autoconfigure;

import org.jspecify.annotations.Nullable;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.Assert;

@ConfigurationProperties(value="spring.h2.console")
public class H2ConsoleProperties {
    private String path = "/h2-console";
    private boolean enabled = false;
    private final Settings settings = new Settings();

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        Assert.notNull((Object)path, (String)"'path' must not be null");
        Assert.isTrue((path.length() > 1 ? 1 : 0) != 0, (String)"'path' must have length greater than 1");
        Assert.isTrue((boolean)path.startsWith("/"), (String)"'path' must start with '/'");
        this.path = path;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public static class Settings {
        private boolean trace = false;
        private boolean webAllowOthers = false;
        private @Nullable String webAdminPassword;

        public boolean isTrace() {
            return this.trace;
        }

        public void setTrace(boolean trace) {
            this.trace = trace;
        }

        public boolean isWebAllowOthers() {
            return this.webAllowOthers;
        }

        public void setWebAllowOthers(boolean webAllowOthers) {
            this.webAllowOthers = webAllowOthers;
        }

        public @Nullable String getWebAdminPassword() {
            return this.webAdminPassword;
        }

        public void setWebAdminPassword(@Nullable String webAdminPassword) {
            this.webAdminPassword = webAdminPassword;
        }
    }
}

